
package ietf.params.xml.ns.icalendar_2;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;


/**
 * 
 *         From RFC 5545 Section 3.6.4
 *        freebusyc  = "BEGIN" ":" "VFREEBUSY" CRLF
 *                     fbprop
 *                     "END" ":" "VFREEBUSY" CRLF
 * 
 *        fbprop     = *(
 *                   ;
 *                   ; The following are REQUIRED,
 *                   ; but MUST NOT occur more than once.
 *                   ;
 *                   dtstamp / uid /
 *                   ;
 *                   ; The following are OPTIONAL,
 *                   ; but MUST NOT occur more than once.
 *                   ;
 *                   contact / dtstart / dtend /
 *                   organizer / url /
 *                   ;
 *                   ; The following are OPTIONAL,
 *                   ; and MAY occur more than once.
 *                   ;
 *                   attendee / comment / freebusy / rstatus / x-prop /
 *                   iana-prop
 *                   ;
 *                   )
 *       
 * 
 * <p>Java class for ArrayOfFreebusyContainedProperties complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="ArrayOfFreebusyContainedProperties"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;choice maxOccurs="unbounded" minOccurs="0"&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}dtstamp"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}uid"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}contact"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}dtend"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}dtstart"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}organizer"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}url"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}attendee"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}comment"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}freebusy"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}request-status"/&gt;
 *         &lt;/choice&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ArrayOfFreebusyContainedProperties", propOrder = {
    "dtstampOrUidOrContact"
})
public class ArrayOfFreebusyContainedProperties {

    @XmlElements({
        @XmlElement(name = "dtstamp", type = DtstampPropType.class),
        @XmlElement(name = "uid", type = UidPropType.class),
        @XmlElement(name = "contact", type = ContactPropType.class),
        @XmlElement(name = "dtend", type = DtendPropType.class),
        @XmlElement(name = "dtstart", type = DtstartPropType.class),
        @XmlElement(name = "organizer", type = OrganizerPropType.class),
        @XmlElement(name = "url", type = UrlPropType.class),
        @XmlElement(name = "attendee", type = AttendeePropType.class),
        @XmlElement(name = "comment", type = CommentPropType.class),
        @XmlElement(name = "freebusy", type = FreebusyPropType.class),
        @XmlElement(name = "request-status", type = RequestStatusPropType.class)
    })
    protected List<BasePropertyType> dtstampOrUidOrContact;

    /**
     * Gets the value of the dtstampOrUidOrContact property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the dtstampOrUidOrContact property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDtstampOrUidOrContact().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DtstampPropType }
     * {@link UidPropType }
     * {@link ContactPropType }
     * {@link DtendPropType }
     * {@link DtstartPropType }
     * {@link OrganizerPropType }
     * {@link UrlPropType }
     * {@link AttendeePropType }
     * {@link CommentPropType }
     * {@link FreebusyPropType }
     * {@link RequestStatusPropType }
     * 
     * 
     */
    public List<BasePropertyType> getDtstampOrUidOrContact() {
        if (dtstampOrUidOrContact == null) {
            dtstampOrUidOrContact = new ArrayList<BasePropertyType>();
        }
        return this.dtstampOrUidOrContact;
    }

}
