
package ietf.params.xml.ns.icalendar_2;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;


/**
 * 
 *         From RFC 5545 Section 3.6.1
 *        eventc     = "BEGIN" ":" "VEVENT" CRLF
 *                     eventprop *alarmc
 *                     "END" ":" "VEVENT" CRLF
 * 
 *        eventprop  = *(
 *                   ;
 *                   ; The following are REQUIRED,
 *                   ; but MUST NOT occur more than once.
 *                   ;
 *                   dtstamp / uid /
 *                   ;
 *                   ; The following is REQUIRED if the component
 *                   ; appears in an iCalendar object that doesn't
 *                   ; specify the "METHOD" property; otherwise, it
 *                   ; is OPTIONAL; in any case, it MUST NOT occur
 *                   ; more than once.
 *                   ;
 *                   dtstart /
 *                   ;
 *                   ; The following are OPTIONAL,
 *                   ; but MUST NOT occur more than once.
 *                   ;
 *                   class / created / description / geo /
 *                   last-mod / location / organizer / priority /
 *                   seq / status / summary / transp /
 *                   url / recurid /
 *                   ;
 *                   ; The following is OPTIONAL,
 *                   ; but SHOULD NOT occur more than once.
 *                   ;
 *                   rrule /
 *                   ;
 *                   ; Either 'dtend' or 'duration' MAY appear in
 *                   ; a 'eventprop', but 'dtend' and 'duration'
 *                   ; MUST NOT occur in the same 'eventprop'.
 *                   ;
 *                   dtend / duration /
 *                   ;
 *                   ; The following are OPTIONAL,
 *                   ; and MAY occur more than once.
 *                   ;
 *                   attach / attendee / categories / comment /
 *                   contact / exdate / rstatus / related /
 *                   resources / rdate / x-prop / iana-prop
 *                   ;
 *                   )
 *       
 * 
 * <p>Java class for ArrayOfEventContainedProperties complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="ArrayOfEventContainedProperties"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;choice maxOccurs="unbounded" minOccurs="0"&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}dtstamp"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}uid"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}dtstart"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}class"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}created"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}description"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}geo"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}last-modified"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}location"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}organizer"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}priority"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}recurrence-id"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}sequence"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}status"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}summary"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}transp"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}url"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}rrule"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}exrule"/&gt;
 *           &lt;choice&gt;
 *             &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}dtend"/&gt;
 *             &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}duration"/&gt;
 *           &lt;/choice&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}attach"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}attendee"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}categories"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}comment"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}contact"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}exdate"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}request-status"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}related"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}resources"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}rdate"/&gt;
 *         &lt;/choice&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ArrayOfEventContainedProperties", propOrder = {
    "dtstampOrUidOrDtstart"
})
public class ArrayOfEventContainedProperties {

    @XmlElements({
        @XmlElement(name = "dtstamp", type = DtstampPropType.class),
        @XmlElement(name = "uid", type = UidPropType.class),
        @XmlElement(name = "dtstart", type = DtstartPropType.class),
        @XmlElement(name = "class", type = ClassPropType.class),
        @XmlElement(name = "created", type = CreatedPropType.class),
        @XmlElement(name = "description", type = DescriptionPropType.class),
        @XmlElement(name = "geo", type = GeoPropType.class),
        @XmlElement(name = "last-modified", type = LastModifiedPropType.class),
        @XmlElement(name = "location", type = LocationPropType.class),
        @XmlElement(name = "organizer", type = OrganizerPropType.class),
        @XmlElement(name = "priority", type = PriorityPropType.class),
        @XmlElement(name = "recurrence-id", type = RecurrenceIdPropType.class),
        @XmlElement(name = "sequence", type = SequencePropType.class),
        @XmlElement(name = "status", type = StatusPropType.class),
        @XmlElement(name = "summary", type = SummaryPropType.class),
        @XmlElement(name = "transp", type = TranspPropType.class),
        @XmlElement(name = "url", type = UrlPropType.class),
        @XmlElement(name = "rrule", type = RrulePropType.class),
        @XmlElement(name = "exrule", type = ExrulePropType.class),
        @XmlElement(name = "dtend", type = DtendPropType.class),
        @XmlElement(name = "duration", type = DurationPropType.class),
        @XmlElement(name = "attach", type = AttachPropType.class),
        @XmlElement(name = "attendee", type = AttendeePropType.class),
        @XmlElement(name = "categories", type = CategoriesPropType.class),
        @XmlElement(name = "comment", type = CommentPropType.class),
        @XmlElement(name = "contact", type = ContactPropType.class),
        @XmlElement(name = "exdate", type = ExdatePropType.class),
        @XmlElement(name = "request-status", type = RequestStatusPropType.class),
        @XmlElement(name = "related", type = RelatedParamType.class),
        @XmlElement(name = "resources", type = ResourcesPropType.class),
        @XmlElement(name = "rdate", type = RdatePropType.class)
    })
    protected List<Object> dtstampOrUidOrDtstart;

    /**
     * Gets the value of the dtstampOrUidOrDtstart property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the dtstampOrUidOrDtstart property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDtstampOrUidOrDtstart().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DtstampPropType }
     * {@link UidPropType }
     * {@link DtstartPropType }
     * {@link ClassPropType }
     * {@link CreatedPropType }
     * {@link DescriptionPropType }
     * {@link GeoPropType }
     * {@link LastModifiedPropType }
     * {@link LocationPropType }
     * {@link OrganizerPropType }
     * {@link PriorityPropType }
     * {@link RecurrenceIdPropType }
     * {@link SequencePropType }
     * {@link StatusPropType }
     * {@link SummaryPropType }
     * {@link TranspPropType }
     * {@link UrlPropType }
     * {@link RrulePropType }
     * {@link ExrulePropType }
     * {@link DtendPropType }
     * {@link DurationPropType }
     * {@link AttachPropType }
     * {@link AttendeePropType }
     * {@link CategoriesPropType }
     * {@link CommentPropType }
     * {@link ContactPropType }
     * {@link ExdatePropType }
     * {@link RequestStatusPropType }
     * {@link RelatedParamType }
     * {@link ResourcesPropType }
     * {@link RdatePropType }
     * 
     * 
     */
    public List<Object> getDtstampOrUidOrDtstart() {
        if (dtstampOrUidOrDtstart == null) {
            dtstampOrUidOrDtstart = new ArrayList<Object>();
        }
        return this.dtstampOrUidOrDtstart;
    }

}
