/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch.shared.cnctrs;

import java.util.HashMap;
import java.util.Map;
import org.bedework.synch.shared.Subscription;
import org.bedework.synch.shared.cnctrs.ConnectorInstance;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.synch.wsmessages.SynchEndType;

public class ConnectorInstanceMap<CI extends ConnectorInstance> {
    private Map<Key, CI> theMap = new HashMap<Key, CI>();

    public synchronized void add(Subscription sub, SynchEndType end, CI cinst) throws SynchException {
        Key key = new Key(sub, end);
        if (this.theMap.containsKey(key)) {
            throw new SynchException("instance already in map for " + key);
        }
        this.theMap.put(key, cinst);
    }

    public synchronized CI find(Subscription sub, SynchEndType end) throws SynchException {
        return (CI)((ConnectorInstance)this.theMap.get(new Key(sub, end)));
    }

    public synchronized void remove(Subscription sub, SynchEndType end) throws SynchException {
        this.theMap.remove(new Key(sub, end));
    }

    static class Key {
        Subscription sub;
        SynchEndType end;

        Key(Subscription sub, SynchEndType end) {
            this.sub = sub;
            this.end = end;
        }

        public int hashCode() {
            return this.sub.hashCode() * this.end.hashCode();
        }

        public boolean equals(Object o) {
            Key that = (Key)o;
            if (that.end != this.end) {
                return false;
            }
            return this.sub.equals(that.sub);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("{");
            sb.append("sub=");
            sb.append(this.sub);
            sb.append(", end=");
            sb.append(this.end);
            sb.append("}");
            return sb.toString();
        }
    }
}

