/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch.shared;

import ietf.params.xml.ns.icalendar_2.IcalendarType;
import java.util.ArrayList;
import java.util.List;
import org.bedework.synch.shared.Subscription;
import org.bedework.synch.wsmessages.SubscribeResponseType;
import org.bedework.synch.wsmessages.SubscriptionStatusRequestType;
import org.bedework.synch.wsmessages.SubscriptionStatusResponseType;
import org.bedework.synch.wsmessages.SynchEndType;
import org.bedework.synch.wsmessages.UnsubscribeRequestType;
import org.bedework.synch.wsmessages.UnsubscribeResponseType;

public class Notification<NI extends NotificationItem> {
    private Subscription sub;
    private String subscriptionId;
    private SynchEndType end;
    private List<NI> notifications = new ArrayList<NI>();

    public Notification(Subscription sub) {
        this.sub = sub;
        if (sub != null) {
            this.subscriptionId = sub.getSubscriptionId();
        }
    }

    public Notification(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public Notification(Subscription sub, SynchEndType end) {
        this(sub);
        this.end = end;
    }

    public Notification(Subscription sub, SynchEndType end, NI notificationItem) {
        this(sub, end);
        this.addNotificationItem(notificationItem);
    }

    public Notification(Subscription sub, SubscribeResponseType response) {
        this(sub, SynchEndType.NONE);
        this.addNotificationItem(new NotificationItem(response));
    }

    public Notification(Subscription sub, UnsubscribeRequestType request, UnsubscribeResponseType response) {
        this(sub, SynchEndType.NONE);
        this.addNotificationItem(new NotificationItem(request, response));
    }

    public Notification(Subscription sub, SubscriptionStatusRequestType request, SubscriptionStatusResponseType response) {
        this(sub, SynchEndType.NONE);
        this.addNotificationItem(new NotificationItem(request, response));
    }

    public Notification(NotificationItem.ActionType action) {
        this.addNotificationItem(new NotificationItem(action));
    }

    public Subscription getSub() {
        return this.sub;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public SynchEndType getEnd() {
        return this.end;
    }

    public List<NI> getNotifications() {
        return this.notifications;
    }

    public void addNotificationItem(NI val) {
        this.notifications.add(val);
    }

    protected void toStringSegment(StringBuilder sb) {
        sb.append("sub=");
        sb.append(this.getSub());
        sb.append(", end=");
        sb.append(this.getEnd());
        String delim = ",\n   notification items{\n      ";
        for (NotificationItem ni : this.getNotifications()) {
            sb.append(delim);
            sb.append(ni.toString());
            delim = ",\n      ";
        }
        if (this.getNotifications().size() > 0) {
            sb.append("}");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("{");
        this.toStringSegment(sb);
        sb.append("}");
        return sb.toString();
    }

    public static class NotificationItem {
        private ActionType action;
        private IcalendarType ical;
        private String uid;
        private SubscribeResponseType subResponse;
        private UnsubscribeRequestType unsubRequest;
        private UnsubscribeResponseType unsubResponse;
        private SubscriptionStatusRequestType subStatusReq;
        private SubscriptionStatusResponseType subStatusResponse;

        public NotificationItem(ActionType action) {
            this.action = action;
        }

        public NotificationItem(ActionType action, IcalendarType ical, String uid) {
            this(action);
            this.ical = ical;
            this.uid = uid;
        }

        public NotificationItem(SubscribeResponseType subResponse) {
            this.action = ActionType.NewSubscription;
            this.subResponse = subResponse;
        }

        public NotificationItem(UnsubscribeRequestType unsubRequest, UnsubscribeResponseType unsubResponse) {
            this.action = ActionType.Unsubscribe;
            this.unsubRequest = unsubRequest;
            this.unsubResponse = unsubResponse;
        }

        public NotificationItem(SubscriptionStatusRequestType subStatusReq, SubscriptionStatusResponseType subStatusResponse) {
            this.action = ActionType.SubscriptionStatus;
            this.subStatusReq = subStatusReq;
            this.subStatusResponse = subStatusResponse;
        }

        public ActionType getAction() {
            return this.action;
        }

        public IcalendarType getIcal() {
            return this.ical;
        }

        public String getUid() {
            return this.uid;
        }

        public SubscribeResponseType getSubResponse() {
            return this.subResponse;
        }

        public UnsubscribeRequestType getUnsubRequest() {
            return this.unsubRequest;
        }

        public UnsubscribeResponseType getUnsubResponse() {
            return this.unsubResponse;
        }

        public SubscriptionStatusRequestType getSubStatusReq() {
            return this.subStatusReq;
        }

        public SubscriptionStatusResponseType getSubStatusResponse() {
            return this.subStatusResponse;
        }

        protected void toStringSegment(StringBuilder sb) {
            sb.append("action=");
            sb.append((Object)this.getAction());
            sb.append("uid=");
            sb.append(this.getUid());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("{");
            this.toStringSegment(sb);
            sb.append("}");
            return sb.toString();
        }

        public static enum ActionType {
            FullSynch,
            CopiedEvent,
            CreatedEvent,
            DeletedEvent,
            ModifiedEvent,
            MovedEvent,
            NewMailEvent,
            StatusEvent,
            NewSubscription,
            Unsubscribe,
            SubscriptionStatus,
            GetInfo;

        }
    }
}

