/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.bwcli.copiedCalFacade.responses;

import java.io.Serializable;
import org.bedework.util.misc.ToString;

public class Response
implements Serializable {
    private Status status = Status.ok;
    private String message;
    private int id;

    public void setStatus(Status val) {
        this.status = val;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setMessage(String val) {
        this.message = val;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isOk() {
        return this.status == Status.ok;
    }

    public void setId(int val) {
        this.id = val;
    }

    public int getId() {
        return this.id;
    }

    public static Response ok() {
        return Response.ok(new Response(), null);
    }

    public static <T extends Response> T ok(T resp, String msg) {
        resp.setStatus(Status.ok);
        resp.setMessage(msg);
        return resp;
    }

    public static <T extends Response> T notOk(T resp, Status status, String msg) {
        resp.setStatus(status);
        resp.setMessage(msg);
        return resp;
    }

    public static <T extends Response> T error(T resp, String msg) {
        return Response.notOk(resp, Status.failed, msg);
    }

    public static <T extends Response> T error(T resp, Throwable t) {
        return Response.error(resp, t.getLocalizedMessage());
    }

    public static <T extends Response> T invalid(T resp, String msg) {
        return Response.notOk(resp, Status.validationError, msg);
    }

    public void toStringSegment(ToString ts) {
        ts.append("status", (Object)this.getStatus()).append("message", (Object)this.getMessage()).append("id", this.getId());
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        return ts.toString();
    }

    public static enum Status {
        ok,
        notFound,
        validationError,
        processing,
        exists,
        failed;

    }
}

