/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.bwcli.copiedCalFacade;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.bedework.bwcli.copiedCalFacade.BwPrincipal;
import org.bedework.util.misc.ToString;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
public class BwGroup
extends BwPrincipal {
    private Collection<BwPrincipal> groupMembers;

    @Override
    public int getKind() {
        return 2;
    }

    public void setGroupMembers(Collection<BwPrincipal> val) {
        this.groupMembers = val;
    }

    public Collection<BwPrincipal> getGroupMembers() {
        return this.groupMembers;
    }

    public boolean isMember(String account, boolean group) {
        Collection<BwPrincipal> ms = this.getGroupMembers();
        if (ms == null) {
            return false;
        }
        for (BwPrincipal mbr : ms) {
            if (!mbr.getAccount().equals(account) || group != mbr instanceof BwGroup) continue;
            return true;
        }
        return false;
    }

    public boolean addGroupMember(BwPrincipal mbr) {
        Collection<BwPrincipal> ms = this.getGroupMembers();
        if (ms == null) {
            ms = new TreeSet<BwPrincipal>();
            this.setGroupMembers(ms);
        }
        return ms.add(mbr);
    }

    public boolean removeGroupMember(BwPrincipal mbr) {
        Collection<BwPrincipal> ms = this.getGroupMembers();
        if (ms == null) {
            return false;
        }
        return this.getGroupMembers().remove(mbr);
    }

    @Override
    protected void toStringSegment(ToString ts) {
        super.toStringSegment(ts);
        ArrayList<String> refs = new ArrayList<String>();
        Collection<BwPrincipal> ms = this.getGroupMembers();
        if (ms != null) {
            for (BwPrincipal mbr : ms) {
                refs.add(mbr.getPrincipalRef());
            }
        }
        ts.newLine().append("groupMembers", refs);
    }

    public void copyTo(BwGroup val) {
        super.copyTo(val);
        Collection<BwPrincipal> ms = this.getGroupMembers();
        if (ms != null) {
            for (BwPrincipal mbr : ms) {
                val.addGroupMember((BwPrincipal)mbr.clone());
            }
        }
    }

    public void shallowCopyTo(BwGroup val) {
        super.copyTo(val);
    }

    public BwGroup shallowClone() {
        BwGroup g = new BwGroup();
        this.shallowCopyTo(g);
        return g;
    }

    @Override
    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        return ts.toString();
    }

    @Override
    public Object clone() {
        BwGroup g = new BwGroup();
        this.copyTo(g);
        return g;
    }
}

