/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.bwcli;

import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.bedework.bwcli.logs.LogEntry;
import org.bedework.bwcli.logs.ReqInOutLogEntry;
import org.bedework.util.misc.Util;

public class LogAnalysis {
    long totalRequests;
    long totalForwardedRequests;
    long errorLines;
    long unterminatedTask;
    boolean showLong;
    boolean showMissingTaskIds;
    boolean summariseTests;
    int waitcountCount;
    LogEntry lastReqline;
    LogEntry lastEntry;
    boolean dumpIndented;
    final String wildflyStart = "[org.jboss.as] (Controller Boot Thread) WFLYSRV0025";
    final Map<String, Integer> longreqIpMap = new HashMap<String, Integer>();
    final Map<String, ReqInOutLogEntry> tasks = new HashMap<String, ReqInOutLogEntry>();
    static final int numMilliBuckets = 20;
    static final int milliBucketSize = 100;
    final Map<String, ContextInfo> contexts = new HashMap<String, ContextInfo>();

    public void process(String logPathName, boolean showLong, boolean showMissingTaskIds, boolean summariseTests) {
        this.showLong = showLong;
        this.showMissingTaskIds = showMissingTaskIds;
        this.summariseTests = summariseTests;
        try {
            String s;
            Path logPath = Paths.get(logPathName, new String[0]);
            File logFile = logPath.toFile();
            LineNumberReader lnr = new LineNumberReader(new FileReader(logFile));
            while ((s = lnr.readLine()) != null) {
                if (this.dumpIndented) {
                    if (s.startsWith(" ")) {
                        this.out(s);
                        continue;
                    }
                    this.dumpIndented = false;
                }
                if (this.infoLine(s)) {
                    this.doInfo(s);
                    continue;
                }
                if (summariseTests && this.debugLine(s)) {
                    this.doSummariseTests(s);
                }
                this.checkErrorLine(s);
            }
            this.results();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void doInfo(String s) {
        if (s.contains("[org.jboss.as] (Controller Boot Thread) WFLYSRV0025")) {
            this.tasks.clear();
            return;
        }
        ReqInOutLogEntry rs = this.tryRequestLine(s);
        if (rs != null) {
            ReqInOutLogEntry mapRs;
            if (this.summariseTests) {
                this.lastReqline = rs;
            }
            if ((mapRs = this.tasks.get(rs.taskId)) != null) {
                ++this.unterminatedTask;
            }
            this.tasks.put(rs.taskId, rs);
            return;
        }
        rs = this.tryRequestOut(s);
        if (rs != null) {
            ReqInOutLogEntry mapRs;
            if (this.summariseTests && this.waitcountCount <= 1) {
                this.outSummary(rs);
            }
            if ((mapRs = this.tasks.get(rs.taskId)) == null) {
                if (this.showMissingTaskIds) {
                    String dt = s.substring(0, s.indexOf(" INFO"));
                    this.outFmt("Missing taskid %s %s", rs.taskId, dt);
                }
                return;
            }
            if (mapRs.context == null) {
                this.outFmt("No context for %s %s", mapRs.dt, mapRs.request);
                return;
            }
            if (!mapRs.sameTask(rs)) {
                this.outFmt("Not same task %s\n %s", mapRs.toString(), rs.toString());
                return;
            }
            long reqMillis = rs.millis - mapRs.millis;
            ContextInfo ci = this.contexts.computeIfAbsent(mapRs.context, k -> new ContextInfo(mapRs.context));
            ci.reqOut(s, mapRs, reqMillis);
            if (rs.hasJsessionid()) {
                ++ci.sessions;
            }
            this.tasks.remove(rs.taskId);
        }
    }

    private void doSummariseTests(String s) {
        boolean isWaitcount;
        LogEntry le = new LogEntry();
        if (le.parse(s, null, "DEBUG") == null) {
            this.out(s + " ******************** Unparseable");
            return;
        }
        if (s.contains(" entry: ")) {
            this.lastEntry = le;
            return;
        }
        String testUserAgentLabel = "User-Agent = \"Cal-Tester: ";
        boolean isUserAgent = s.contains("User-Agent = \"");
        boolean isCalTest = s.contains("User-Agent = \"Cal-Tester: ");
        boolean bl = isWaitcount = isCalTest && s.contains("WAITCOUNT ");
        if (isWaitcount) {
            if (this.waitcountCount > 0) {
                ++this.waitcountCount;
                return;
            }
            this.lastEntry = null;
            this.waitcountCount = 1;
        } else if (isUserAgent && this.waitcountCount > 0) {
            this.out(">---------------------------- WAITCOUNT = " + this.waitcountCount);
            this.waitcountCount = 0;
        }
        if (this.waitcountCount > 1) {
            return;
        }
        if (s.contains(" User-Agent = \"")) {
            this.outSummary(this.lastReqline);
            this.outSummary(this.lastEntry);
            int pos = le.logText.indexOf("User-Agent = \"Cal-Tester: ");
            if (pos >= 0) {
                le.logText = "------------- Test ---> " + le.logText.substring(0, pos) + le.logText.substring(pos + "User-Agent = \"Cal-Tester: ".length(), le.logText.length() - 1) + "<------------------";
                this.outSummary(le);
            }
            return;
        }
        if (s.contains(" getRequestURI =")) {
            this.outSummary(le);
            return;
        }
        if (s.contains(" getRemoteUser =")) {
            this.outSummary(le);
            return;
        }
        if (s.contains("=BwInoutSched")) {
            this.outSchedSummary(le);
            return;
        }
    }

    private void outSummary(LogEntry le) {
        if (le == null) {
            return;
        }
        this.outFmt("%s %-4s %-8s %s %s", le.dt, le.sinceLastMillis, le.sinceStartMillis, this.taskIdSummary(le), le.logText);
    }

    private String taskIdSummary(LogEntry le) {
        if (le.taskId.startsWith("default ")) {
            return le.taskId.substring(8);
        }
        if (le.taskId.startsWith("org.bedework.bwengine:service=")) {
            return le.taskId.substring(30);
        }
        return le.taskId;
    }

    private void outSchedSummary(LogEntry le) {
        String s = le.logText;
        if (s.contains("set event to")) {
            this.outSummary(le);
            return;
        }
        if (s.contains("Indexing to")) {
            this.outSummary(le);
        }
        if (s.contains("Add event with name")) {
            this.outSummary(le);
        }
        if (s.contains("Received messageEntityQueuedEvent")) {
            this.outSummary(le);
            this.dumpIndented = true;
        }
    }

    private ReqInOutLogEntry tryRequestLine(String ln) {
        return this.tryRequestInOutLine(ln, true);
    }

    private ReqInOutLogEntry tryRequestOut(String ln) {
        return this.tryRequestInOutLine(ln, false);
    }

    private ReqInOutLogEntry tryRequestInOutLine(String ln, boolean in) {
        ReqInOutLogEntry rs = new ReqInOutLogEntry();
        Integer res = rs.parse(ln, in);
        if (res == null || res < 0) {
            return null;
        }
        return rs;
    }

    private boolean infoLine(String ln) {
        return ln.indexOf(" INFO ") == 23;
    }

    private boolean debugLine(String ln) {
        return ln.indexOf(" DEBUG ") == 23;
    }

    private void checkErrorLine(String ln) {
        if (ln.indexOf(" ERROR ") != 23) {
            return;
        }
        ++this.errorLines;
    }

    private void results() {
        this.outFmt("Total requests: %d", this.totalRequests);
        if (this.totalForwardedRequests != this.totalRequests) {
            this.outFmt("Total forwarded requests: %d", this.totalForwardedRequests);
        }
        this.outFmt("Millis per request by context per 100 millis", new Object[0]);
        TreeSet<String> contextNames = new TreeSet<String>(this.contexts.keySet());
        String labelPattern = " %6s |";
        ContextInfo[] cis = new ContextInfo[contextNames.size()];
        String[] cellFormats = new String[contextNames.size()];
        String[] hdrFormats = new String[contextNames.size()];
        int cx = 0;
        StringBuilder header = new StringBuilder(String.format(" %6s |", ""));
        for (String context : contextNames) {
            ContextInfo ci;
            cis[cx] = ci = this.contexts.get(context);
            int fldLen = Math.max(context.length(), 5);
            cellFormats[cx] = " %" + fldLen + "s - %3s%% |";
            String hdrFmt = "        %" + fldLen + "s |";
            hdrFormats[cx] = hdrFmt;
            header.append(String.format(hdrFmt, context));
            ++cx;
        }
        this.outFmt("%s", header);
        for (int i = 0; i < 20; ++i) {
            StringBuilder l = new StringBuilder(String.format(" %6s |", "<" + (i + 1) * 100));
            for (int j = 0; j < cis.length; ++j) {
                ContextInfo ci = cis[j];
                l.append(String.format(cellFormats[j], ci.buckets[i], (int)(100L * ci.rTotalReq / ci.requests)));
                ci.rTotalReq += ci.buckets[i];
            }
            this.outFmt("%s", l);
        }
        StringBuilder sessReq = new StringBuilder(String.format(" %6s |", "Sess"));
        StringBuilder totReq = new StringBuilder(String.format(" %6s |", "Total"));
        StringBuilder avgMs = new StringBuilder(String.format(" %6s |", "Avg ms"));
        StringBuilder subTtotReq = new StringBuilder(String.format(" %6s |", "Total"));
        StringBuilder subTavgMs = new StringBuilder(String.format(" %6s |", "Avg ms"));
        for (int j = 0; j < cis.length; ++j) {
            ContextInfo ci = cis[j];
            sessReq.append(String.format(hdrFormats[j], ci.sessions));
            totReq.append(String.format(hdrFormats[j], ci.requests));
            avgMs.append(String.format(hdrFormats[j], (int)(ci.totalMillis / ci.requests)));
            subTtotReq.append(String.format(hdrFormats[j], ci.subTrequests));
            subTavgMs.append(String.format(hdrFormats[j], (int)(ci.subTtotalMillis / ci.subTrequests)));
        }
        this.outFmt("%s", sessReq);
        this.outFmt("%s", totReq);
        this.outFmt("%s", avgMs);
        this.outFmt("%s", "Figures ignoring highest bucket:");
        this.outFmt("%s", subTtotReq);
        this.outFmt("%s", subTavgMs);
        this.out();
        this.outFmt("Total error lines: %d", this.errorLines);
        this.out();
        int numIps = 20;
        this.outFmt("List of top %d ips", 20);
        List sorted = Util.sortMap(ReqInOutLogEntry.ipMap);
        int ct = 0;
        for (Map.Entry ent : sorted) {
            this.outFmt("%s\t%d", ent.getKey(), ent.getValue());
            if (++ct <= 20) continue;
            break;
        }
        this.out();
        this.outFmt("List of top %d long request ips", 20);
        List longSorted = Util.sortMap(this.longreqIpMap);
        ct = 0;
        for (Map.Entry ent : longSorted) {
            this.outFmt("%s\t%d", ent.getKey(), ent.getValue());
            if (++ct <= 20) continue;
            break;
        }
    }

    private void outFmt(String format, Object ... args) {
        System.out.println(String.format(format, args));
    }

    private void out(String val) {
        System.out.println(val);
    }

    private void out() {
        System.out.println();
    }

    class ContextInfo {
        String context;
        long requests;
        long totalMillis;
        long subTrequests;
        long subTtotalMillis;
        long[] buckets = new long[20];
        long rTotalReq;
        long sessions;

        ContextInfo(String context) {
            this.context = context;
        }

        void reqOut(String ln, ReqInOutLogEntry rs, long millis) {
            ++this.requests;
            this.totalMillis += millis;
            int bucket = (int)(millis / 100L);
            if (bucket >= 19) {
                bucket = 19;
                if (LogAnalysis.this.showLong) {
                    String dt = ln.substring(0, ln.indexOf(" INFO"));
                    LogAnalysis.this.outFmt("Long request %s %s %d: %s - %s %s", rs.ip, rs.taskId, millis, rs.dt, dt, rs.request);
                }
                int ct = LogAnalysis.this.longreqIpMap.computeIfAbsent(rs.ip, k -> 0);
                LogAnalysis.this.longreqIpMap.put(rs.ip, ++ct);
            }
            int n = bucket;
            this.buckets[n] = this.buckets[n] + 1L;
            if (bucket < 19) {
                ++this.subTrequests;
                this.subTtotalMillis += millis;
            }
        }
    }
}

