/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.bwcli;

import java.util.Collections;
import java.util.List;
import org.bedework.util.jolokia.JolokiaClient;

public class JolokiaConfigClient
extends JolokiaClient {
    private static final String carddavUserDirMbean = "org.bedework.carddav:service=CardDav,Type=dirhandler,Name=user-dirHandler";
    private static final String notifierMbean = "org.bedework.notify:service=Notify,Type=notifyConf,Name=notifyConf";
    private static final String syncEngineMbean = "org.bedework.synch:service=SynchConf";
    private static final String sysMonitorMbean = "org.bedework.bwengine:service=BwSysMonitor";
    private static final String tzsvrMbean = "org.bedework.timezones:service=TzSvr,Type=tzConf,Name=tzConf";

    public JolokiaConfigClient(String url, String id, String pw) {
        super(url, id, pw);
    }

    public String setCmdutilUser(String account) throws Throwable {
        return this.execCmdutilCmd("user " + account);
    }

    public String execCmdutilCmd(String cmd) throws Throwable {
        return this.execString("org.bedework.bwengine:service=cmdutil", "exec", new Object[]{cmd});
    }

    public List<String> coreSchema(boolean export, String out) throws Throwable {
        return this.doSchema("org.bedework.bwengine.core:service=DbConf", export, out);
    }

    public String listIndexes() throws Throwable {
        return this.execString("org.bedework.bwengine:service=indexing", "listIndexes", new Object[0]);
    }

    public String purgeIndexes() throws Throwable {
        return this.execString("org.bedework.bwengine:service=indexing", "purgeIndexes", new Object[0]);
    }

    public String newIndexes() throws Throwable {
        return this.execString("org.bedework.bwengine:service=indexing", "newIndexes", new Object[0]);
    }

    public List<String> rebuildIndexes() throws Throwable {
        String status;
        this.execute("org.bedework.bwengine:service=indexing", "rebuildIndex", new Object[0]);
        do {
            status = this.waitCompletion("org.bedework.bwengine:service=indexing");
            this.multiLine(this.execStringList("org.bedework.bwengine:service=indexing", "rebuildStatus"));
        } while (status.equals("Timedout"));
        return this.execStringList("org.bedework.bwengine:service=indexing", "rebuildStatus");
    }

    public List<String> sysStats() throws Throwable {
        return this.execStringList(sysMonitorMbean, "showValues");
    }

    public List<String> rebuildEntityIndex(String docType) throws Throwable {
        String status = this.execString("org.bedework.bwengine:service=indexing", "rebuildEntityIndex", new Object[]{docType});
        if (!"Started".equals(status)) {
            return Collections.singletonList("Rebuild start failed: status was " + status);
        }
        do {
            status = this.waitCompletion("org.bedework.bwengine:service=indexing");
            this.multiLine(this.execStringList("org.bedework.bwengine:service=indexing", "rebuildStatus"));
        } while (status.equals("Timedout"));
        return this.execStringList("org.bedework.bwengine:service=indexing", "rebuildStatus");
    }

    public Object indexStats(String indexName) throws Throwable {
        return this.exec("org.bedework.bwengine:service=indexing", "indexStats", new Object[]{indexName});
    }

    public String reindex(String indexName) throws Throwable {
        return this.execString("org.bedework.bwengine:service=indexing", "reindex", new Object[]{indexName});
    }

    public List<String> rebuildIdxStatus() throws Throwable {
        return this.execStringList("org.bedework.bwengine:service=indexing", "rebuildStatus");
    }

    public String makeIdxProd(String indexName) throws Throwable {
        return this.execString("org.bedework.bwengine:service=indexing", "setProdAlias", new Object[]{indexName});
    }

    public String makeAllIdxProd() throws Throwable {
        return this.execString("org.bedework.bwengine:service=indexing", "makeAllProd", new Object[0]);
    }

    public List<String> restoreCalData(String path) throws Throwable {
        if (path != null) {
            this.writeVal("org.bedework.bwengine:service=dumprestore", "DataIn", path);
        }
        this.writeVal("org.bedework.bwengine:service=dumprestore", "AllowRestore", "true");
        this.execute("org.bedework.bwengine:service=dumprestore", "restoreData", new Object[0]);
        this.waitCompletion("org.bedework.bwengine:service=dumprestore");
        return this.execStringList("org.bedework.bwengine:service=dumprestore", "restoreStatus");
    }

    public void setSystemTzid(String val) throws Throwable {
        this.writeVal("org.bedework.bwengine:service=system", "Tzid", val);
    }

    public String getSystemTzid() throws Throwable {
        return this.readString("org.bedework.bwengine:service=system", "Tzid");
    }

    public void setRootUsers(String val) throws Throwable {
        this.writeVal("org.bedework.bwengine:service=system", "RootUsers", val);
    }

    public String getRootUsers() throws Throwable {
        return this.readString("org.bedework.bwengine:service=system", "RootUsers");
    }

    public void setAutoKillMinutes(Integer val) throws Throwable {
        this.writeVal("org.bedework.bwengine:service=system", "AutoKillMinutes", val);
    }

    public Integer getAutoKillMinutes() throws Throwable {
        String s = this.readString("org.bedework.bwengine:service=system", "AutoKillMinutes");
        return Integer.valueOf(s);
    }

    public String getSyncAttr(String attrName) throws Throwable {
        return this.readString(syncEngineMbean, attrName);
    }

    public void setSyncAttr(String attrName, String val) throws Throwable {
        this.writeVal(syncEngineMbean, attrName, val);
    }

    public List<String> syncSchema(boolean export, String out) throws Throwable {
        return this.doSchema(syncEngineMbean, export, out);
    }

    public void syncStart() throws Throwable {
        this.execute(syncEngineMbean, "start", new Object[0]);
    }

    public void syncStop() throws Throwable {
        this.execute(syncEngineMbean, "stop", new Object[0]);
    }

    public String syncResched(String id) throws Throwable {
        return this.execString(syncEngineMbean, "rescheduleNow", new Object[]{id});
    }

    public void setSyncPrivKeys(String val) throws Throwable {
        this.writeVal(syncEngineMbean, "PrivKeys", val);
    }

    public List<String> carddavSchema(boolean export, String out) throws Throwable {
        return this.doSchema(carddavUserDirMbean, export, out);
    }

    public List<String> notifierSchema(boolean export, String out) throws Throwable {
        return this.doSchema(notifierMbean, export, out);
    }

    public String selfregAddUser(String account, String first, String last, String email, String pw) throws Throwable {
        return this.execString("org.bedework.selfreg:service=config", "addUser", new Object[]{account, first, last, email, pw});
    }

    public List<String> selfregSchema(boolean export, String out) throws Throwable {
        return this.doSchema("org.bedework.selfreg:service=config", export, out);
    }

    public List<String> eventregSchema(boolean export, String out) throws Throwable {
        return this.doSchema("org.bedework.eventreg:service=eventreg", export, out);
    }

    public void setAttr(String mbean, String attrName, String val) throws Throwable {
        this.writeVal(mbean, attrName, val);
    }

    public List<String> doSchema(String mbean, boolean export, String out) throws Throwable {
        this.writeVal(mbean, "Export", String.valueOf(export));
        if (out != null) {
            this.writeVal(mbean, "SchemaOutFile", out);
        }
        this.execute(mbean, "schema", new Object[0]);
        this.waitCompletion(mbean);
        return this.execStringList(mbean, "schemaStatus");
    }

    public String getTzAttr(String attrName) throws Throwable {
        return this.readString(tzsvrMbean, attrName);
    }

    public void setTzAttr(String attrName, String val) throws Throwable {
        this.writeVal(tzsvrMbean, attrName, val);
    }

    public String tzRefreshData() throws Throwable {
        return this.execString(tzsvrMbean, "refreshData", new Object[0]);
    }
}

