/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swt.table;

import java.util.ArrayList;
import java.util.List;
import org.beanfabrics.Path;
import org.beanfabrics.swt.table.ViewConfig;

public class ViewConfigBuilder {
    private List<Column> columns = new ArrayList<Column>();

    public ViewConfigBuilder addColumn(Path path, String header, int width) {
        Column newCol = new Column();
        newCol.path = path;
        newCol.header = header;
        newCol.width = width;
        this.columns.add(newCol);
        return this;
    }

    public ViewConfigBuilder addColumn(Path path) {
        Column newCol = new Column();
        newCol.path = path;
        this.columns.add(newCol);
        return this;
    }

    public ViewConfigBuilder addColumn() {
        Column newCol = new Column();
        this.columns.add(newCol);
        return this;
    }

    public ViewConfigBuilder setPath(Path path) {
        Column col = this.columns.get(this.columns.size() - 1);
        col.path = path;
        return this;
    }

    public ViewConfigBuilder setPath(String pathStr) {
        Column col = this.columns.get(this.columns.size() - 1);
        col.path = new Path(pathStr);
        return this;
    }

    public ViewConfigBuilder setHeader(String header) {
        Column col = this.columns.get(this.columns.size() - 1);
        col.header = header;
        return this;
    }

    public ViewConfigBuilder setWidth(int width) {
        Column col = this.columns.get(this.columns.size() - 1);
        col.width = width;
        return this;
    }

    public ViewConfig buildViewConfig() {
        List<ViewConfig.Column> cols = this.buildViewConfigColumns();
        ViewConfig result = new ViewConfig(cols);
        return result;
    }

    private List<ViewConfig.Column> buildViewConfigColumns() {
        ArrayList<ViewConfig.Column> result = new ArrayList<ViewConfig.Column>(this.columns.size());
        for (Column col : this.columns) {
            ViewConfig.Column resEntry = new ViewConfig.Column(col.path, col.header, col.width);
            result.add(resEntry);
        }
        return result;
    }

    private class Column {
        Path path;
        String header;
        int width;

        private Column() {
        }
    }
}

