/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swt.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import org.beanfabrics.IModelProvider;
import org.beanfabrics.Link;
import org.beanfabrics.ModelSubscriber;
import org.beanfabrics.Path;
import org.beanfabrics.PathEvaluation;
import org.beanfabrics.View;
import org.beanfabrics.event.ElementChangedEvent;
import org.beanfabrics.event.ElementsAddedEvent;
import org.beanfabrics.event.ElementsDeselectedEvent;
import org.beanfabrics.event.ElementsRemovedEvent;
import org.beanfabrics.event.ElementsReplacedEvent;
import org.beanfabrics.event.ElementsSelectedEvent;
import org.beanfabrics.event.ListListener;
import org.beanfabrics.event.WeakListListener;
import org.beanfabrics.event.WeakPropertyChangeListener;
import org.beanfabrics.log.Logger;
import org.beanfabrics.log.LoggerFactory;
import org.beanfabrics.model.IListPM;
import org.beanfabrics.model.ITextPM;
import org.beanfabrics.model.PresentationModel;
import org.beanfabrics.swt.AbstractDecorator;
import org.beanfabrics.swt.model.IImagePM;
import org.beanfabrics.swt.table.ViewConfig;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class BnTableDecorator
extends AbstractDecorator<Table>
implements View<IListPM<? extends PresentationModel>>,
ModelSubscriber {
    private static Logger LOG = LoggerFactory.getLogger(BnTableDecorator.class);
    private final Link link = new Link((View)this);
    private final PropertyChangeListener listener = new WeakPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(".propertyChange()");
            }
        }
    };
    private final ListListener listListener = new WeakListListener(){

        public void elementsSelected(ElementsSelectedEvent evt) {
            int start = evt.getBeginIndex();
            int end = start + evt.getLength() - 1;
            if (LOG.isDebugEnabled()) {
                LOG.debug(".elementsSelected() " + start + "-" + end);
            }
            BnTableDecorator.this.table.select(start, end);
            BnTableDecorator.this.table.showSelection();
        }

        public void elementsReplaced(ElementsReplacedEvent evt) {
            int start = evt.getBeginIndex();
            int end = start + evt.getLength() - 1;
            if (LOG.isDebugEnabled()) {
                LOG.debug(".elementsReplaced() " + start + "-" + end);
            }
            BnTableDecorator.this.table.remove(start, end);
            for (int idx = start; idx <= end; ++idx) {
                PresentationModel rowModel = BnTableDecorator.this.pModel.getAt(idx);
                BnTableDecorator.this.addTableItem(rowModel, idx);
                if (!BnTableDecorator.this.pModel.getSelection().contains(idx)) continue;
                BnTableDecorator.this.table.select(idx);
            }
        }

        public void elementsRemoved(ElementsRemovedEvent evt) {
            int start = evt.getBeginIndex();
            int end = start + evt.getLength() - 1;
            BnTableDecorator.this.table.remove(start, end);
        }

        public void elementsDeselected(ElementsDeselectedEvent evt) {
            int start = evt.getBeginIndex();
            int end = start + evt.getLength() - 1;
            if (LOG.isDebugEnabled()) {
                LOG.debug(".elementsDeselected() " + start + "-" + end);
            }
            BnTableDecorator.this.table.deselect(start, end);
        }

        public void elementsAdded(ElementsAddedEvent evt) {
            int start = evt.getBeginIndex();
            int end = start + evt.getLength() - 1;
            for (int idx = start; idx <= end; ++idx) {
                PresentationModel rowModel = BnTableDecorator.this.pModel.getAt(idx);
                BnTableDecorator.this.addTableItem(rowModel, idx);
                if (!BnTableDecorator.this.pModel.getSelection().contains(idx)) continue;
                BnTableDecorator.this.table.select(idx);
            }
        }

        public void elementChanged(ElementChangedEvent evt) {
            int index = evt.getIndex();
            if (LOG.isDebugEnabled()) {
                LOG.debug(".elementChanged() " + index);
            }
            if (index >= BnTableDecorator.this.table.getItemCount()) {
                return;
            }
            BnTableDecorator.this.refreshTableItem(index);
        }
    };
    private final SelectionListener uiSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent evt) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(".widgetSelected() evt=" + evt);
            }
            BnTableDecorator.this.updateModelSelection();
        }

        public void widgetDefaultSelected(SelectionEvent evt) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(".widgetDefaultSelected() evt=" + evt);
            }
            BnTableDecorator.this.updateModelSelection();
        }
    };
    private final Table table;
    private IListPM<? extends PresentationModel> pModel;
    private ViewConfig config;
    private Collection<TableColumn> columns;

    public BnTableDecorator(Table table) {
        super(table);
        this.table = table;
        this.hookControl(this.table);
    }

    public BnTableDecorator(Composite parent, int style) {
        this(new Table(parent, style));
    }

    public BnTableDecorator(Composite parent) {
        this(new Table(parent, 65540));
    }

    protected void hookControl(Table table) {
        table.addSelectionListener(this.uiSelectionListener);
    }

    public void dispose() {
        this.table.removeSelectionListener(this.uiSelectionListener);
        this.table.dispose();
    }

    public IListPM getPresentationModel() {
        return this.pModel;
    }

    public void setPresentationModel(IListPM pModel) {
        if (this.pModel != null) {
            this.pModel.removePropertyChangeListener(this.listener);
            this.pModel.removeListListener(this.listListener);
        }
        this.pModel = pModel;
        if (this.pModel != null) {
            this.pModel.addPropertyChangeListener(this.listener);
            this.pModel.addListListener(this.listListener);
        }
        this.refreshUI();
    }

    public void setViewConfig(ViewConfig aConfig) {
        this.config = aConfig;
        this.refreshUI();
    }

    public void setModelProvider(IModelProvider provider) {
        this.link.setModelProvider(provider);
    }

    public IModelProvider getModelProvider() {
        return this.link.getModelProvider();
    }

    public void setPath(Path path) {
        this.link.setPath(path);
    }

    public Path getPath() {
        return this.link.getPath();
    }

    public Table getTable() {
        return this.table;
    }

    protected void refreshUI() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("BnTable.refreshUI()");
        }
        this.dropColumns();
        this.table.removeAll();
        if (this.pModel != null && this.config != null) {
            this.createColumns();
            this.createRows();
            this.refreshUISelection();
        }
    }

    protected void updateModelSelection() {
        int[] selIndices = this.table.getSelectionIndices();
        this.pModel.getSelection().setIndexes(selIndices);
    }

    protected void refreshUISelection() {
        int[] selIndices = this.pModel.getSelection().getIndexes();
        this.table.setSelection(selIndices);
    }

    private void dropColumns() {
        if (this.columns != null) {
            for (TableColumn col : this.columns) {
                col.dispose();
            }
        }
        this.columns = null;
    }

    private void createColumns() {
        this.columns = new ArrayList<TableColumn>();
        for (ViewConfig.Column col : this.config.getColumns()) {
            TableColumn newCol = new TableColumn(this.getTable(), 0);
            newCol.setMoveable(true);
            newCol.setResizable(true);
            newCol.setText(col.header);
            newCol.setWidth(col.width);
            this.columns.add(newCol);
        }
    }

    private void createRows() {
        int rowIndex = 0;
        for (PresentationModel rowModel : this.pModel) {
            this.addTableItem(rowModel, rowIndex);
            ++rowIndex;
        }
    }

    private TableItem addTableItem(PresentationModel rowModel, int rowIndex) {
        TableItem result = new TableItem(this.table, 0, rowIndex);
        result.setData((Object)rowModel);
        int colIndex = -1;
        for (ViewConfig.Column col : this.config.getColumns()) {
            result.setText(++colIndex, this.getText(rowModel, col));
            result.setImage(colIndex, this.getImage(rowModel, col));
        }
        return result;
    }

    private String getText(PresentationModel rowModel, ViewConfig.Column col) {
        Path path = col.path;
        PresentationModel target = PathEvaluation.evaluateOrNull((PresentationModel)rowModel, (Path)path);
        if (target != null && target instanceof ITextPM) {
            ITextPM textModel = (ITextPM)target;
            return textModel.getText();
        }
        return "";
    }

    private Image getImage(PresentationModel rowModel, ViewConfig.Column col) {
        Path path = col.path;
        PresentationModel target = PathEvaluation.evaluateOrNull((PresentationModel)rowModel, (Path)path);
        if (target != null && target instanceof IImagePM) {
            IImagePM imgModel = (IImagePM)target;
            return imgModel.getImage();
        }
        return null;
    }

    protected void refreshTableItem(int index) {
        TableItem item = this.table.getItem(index);
        PresentationModel rowModel = (PresentationModel)item.getData();
        int colIndex = -1;
        for (ViewConfig.Column col : this.config.getColumns()) {
            item.setText(++colIndex, this.getText(rowModel, col));
            item.setImage(colIndex, this.getImage(rowModel, col));
        }
    }
}

