/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.beanfabrics.IModelProvider;
import org.beanfabrics.Link;
import org.beanfabrics.ModelSubscriber;
import org.beanfabrics.Path;
import org.beanfabrics.View;
import org.beanfabrics.event.WeakPropertyChangeListener;
import org.beanfabrics.model.ITextPM;
import org.beanfabrics.swt.AbstractDecorator;
import org.beanfabrics.swt.ValidationIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class BnTextDecorator
extends AbstractDecorator<Text>
implements View<ITextPM>,
ModelSubscriber {
    private final Link link = new Link((View)this);
    private final PropertyChangeListener listener = new WeakPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            BnTextDecorator.this.refreshUI();
        }
    };
    private ValidationIndicator validationIndicator;
    private ITextPM pModel;
    private Text text;

    public BnTextDecorator(Text text) {
        super(text);
        this.text = text;
        this.hookControl(text);
    }

    private void hookControl(Text text) {
        Composite parent = text.getParent();
        if (parent instanceof ValidationIndicator) {
            this.setValidationIndicator((ValidationIndicator)parent);
        }
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                BnTextDecorator.this.updateModel();
            }
        });
        this.refreshUI();
    }

    public BnTextDecorator(Composite parent, int style) {
        this(new Text(parent, style));
    }

    protected void updateModel() {
        if (this.pModel != null) {
            this.pModel.setText(this.text.getText());
        }
    }

    public ITextPM getPresentationModel() {
        return this.pModel;
    }

    public void setPresentationModel(ITextPM pModel) {
        if (this.pModel != null) {
            this.pModel.removePropertyChangeListener(this.listener);
        }
        this.pModel = pModel;
        if (this.pModel != null) {
            this.pModel.addPropertyChangeListener(this.listener);
        }
        this.refreshUI();
    }

    protected void refreshUI() {
        this.refreshEditable();
        this.refreshText();
        this.refreshTooltip();
        this.refreshValidationIndicator();
    }

    protected void refreshEditable() {
        if (this.pModel != null) {
            this.text.setEnabled(this.pModel.isEditable());
        } else {
            this.text.setEnabled(false);
        }
    }

    protected void refreshText() {
        if (this.pModel != null) {
            if (!this.text.getText().equals(this.pModel.getText())) {
                this.text.setText(this.pModel.getText());
            }
        } else {
            this.text.setText("");
        }
    }

    protected void refreshTooltip() {
        if (this.pModel != null) {
            if (!this.pModel.isValid()) {
                this.text.setToolTipText(this.pModel.getValidationState().getMessage());
            } else {
                this.text.setToolTipText(this.pModel.getDescription());
            }
        } else {
            this.text.setToolTipText(null);
        }
    }

    protected void refreshValidationIndicator() {
        if (this.validationIndicator != null) {
            if (this.pModel != null) {
                this.validationIndicator.setValidationState(this.pModel.getValidationState());
            } else {
                this.validationIndicator.setValidationState(null);
            }
        }
    }

    public void setModelProvider(IModelProvider provider) {
        this.link.setModelProvider(provider);
    }

    public IModelProvider getModelProvider() {
        return this.link.getModelProvider();
    }

    public void setPath(Path path) {
        this.link.setPath(path);
    }

    public Path getPath() {
        return this.link.getPath();
    }

    public ValidationIndicator getValidationIndicator() {
        return this.validationIndicator;
    }

    public void setValidationIndicator(ValidationIndicator validationIndicator) {
        this.validationIndicator = validationIndicator;
    }
}

