/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.beanfabrics.IModelProvider;
import org.beanfabrics.Link;
import org.beanfabrics.ModelSubscriber;
import org.beanfabrics.Path;
import org.beanfabrics.View;
import org.beanfabrics.event.WeakPropertyChangeListener;
import org.beanfabrics.model.IIntegerPM;
import org.beanfabrics.swt.AbstractDecorator;
import org.beanfabrics.swt.ValidationIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Spinner;

public class BnSpinnerDecorator
extends AbstractDecorator<Spinner>
implements View<IIntegerPM>,
ModelSubscriber {
    private final Link link = new Link((View)this);
    private final PropertyChangeListener listener = new WeakPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            BnSpinnerDecorator.this.refreshUI();
        }
    };
    private ValidationIndicator validationIndicator;
    private IIntegerPM pModel;
    private Spinner spinner;

    public BnSpinnerDecorator(Spinner spinner) {
        super(spinner);
        this.spinner = spinner;
        this.hookControl(spinner);
    }

    private void hookControl(Spinner spinner) {
        Composite parent = spinner.getParent();
        if (parent instanceof ValidationIndicator) {
            this.setValidationIndicator((ValidationIndicator)parent);
        }
        spinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                BnSpinnerDecorator.this.updateModel();
            }
        });
        this.refreshUI();
    }

    public BnSpinnerDecorator(Composite parent, int style) {
        this(new Spinner(parent, style));
    }

    protected void updateModel() {
        if (this.pModel != null) {
            this.pModel.setText(String.valueOf(this.spinner.getSelection()));
        }
    }

    public IIntegerPM getPresentationModel() {
        return this.pModel;
    }

    public void setPresentationModel(IIntegerPM pModel) {
        if (this.pModel != null) {
            this.pModel.removePropertyChangeListener(this.listener);
        }
        this.pModel = pModel;
        if (this.pModel != null) {
            this.pModel.addPropertyChangeListener(this.listener);
        }
        this.refreshUI();
    }

    protected void refreshUI() {
        this.refreshEditable();
        this.refreshText();
        this.refreshMinMax();
        this.refreshTooltip();
        this.refreshValidationIndicator();
    }

    protected void refreshEditable() {
        if (this.pModel != null) {
            this.spinner.setEnabled(this.pModel.isEditable());
        } else {
            this.spinner.setEnabled(false);
        }
    }

    protected void refreshText() {
        if (this.pModel != null) {
            int pModelInt;
            Integer pModelInteger = this.pModel.getInteger();
            int n = pModelInt = pModelInteger == null ? 0 : pModelInteger;
            if (this.spinner.getSelection() != pModelInt) {
                this.spinner.setSelection(pModelInt);
            }
        } else {
            this.spinner.setSelection(0);
        }
    }

    private void refreshMinMax() {
        if (this.pModel != null) {
            this.spinner.setMinimum((int)this.pModel.getMinValue());
            this.spinner.setMaximum((int)this.pModel.getMaxValue());
        } else {
            this.spinner.setMinimum(Integer.MIN_VALUE);
            this.spinner.setMaximum(Integer.MAX_VALUE);
        }
    }

    protected void refreshTooltip() {
        if (this.pModel != null) {
            if (!this.pModel.isValid()) {
                this.spinner.setToolTipText(this.pModel.getValidationState().getMessage());
            } else {
                this.spinner.setToolTipText(this.pModel.getDescription());
            }
        } else {
            this.spinner.setToolTipText(null);
        }
    }

    protected void refreshValidationIndicator() {
        if (this.validationIndicator != null) {
            if (this.pModel != null) {
                this.validationIndicator.setValidationState(this.pModel.getValidationState());
            } else {
                this.validationIndicator.setValidationState(null);
            }
        }
    }

    public void setModelProvider(IModelProvider provider) {
        this.link.setModelProvider(provider);
    }

    public IModelProvider getModelProvider() {
        return this.link.getModelProvider();
    }

    public void setPath(Path path) {
        this.link.setPath(path);
    }

    public Path getPath() {
        return this.link.getPath();
    }

    public ValidationIndicator getValidationIndicator() {
        return this.validationIndicator;
    }

    public void setValidationIndicator(ValidationIndicator validationIndicator) {
        this.validationIndicator = validationIndicator;
    }
}

