/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.beanfabrics.IModelProvider;
import org.beanfabrics.Link;
import org.beanfabrics.ModelSubscriber;
import org.beanfabrics.Path;
import org.beanfabrics.View;
import org.beanfabrics.event.WeakPropertyChangeListener;
import org.beanfabrics.model.IOperationPM;
import org.beanfabrics.swt.AbstractDecorator;
import org.beanfabrics.util.ExceptionUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class BnPushButtonDecorator
extends AbstractDecorator<Button>
implements View<IOperationPM>,
ModelSubscriber {
    private final Link link = new Link((View)this);
    private final PropertyChangeListener listener = new WeakPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            BnPushButtonDecorator.this.refreshUI();
        }
    };
    private Button button;
    private IOperationPM pModel;
    private boolean textSetManually = false;

    public BnPushButtonDecorator(Button button) {
        super(button);
        this.checkStyle(button.getStyle());
        this.button = button;
        if (button.getText().length() > 0) {
            this.textSetManually = true;
        }
        this.hookControl(button);
    }

    private void checkStyle(int style) {
        if ((style & 8) == 0) {
            throw new IllegalArgumentException("Button must be styled with SWT.PUSH");
        }
    }

    public BnPushButtonDecorator(Composite parent, int style) {
        this(new Button(parent, style));
    }

    public BnPushButtonDecorator(Composite parent) {
        this(new Button(parent, 8));
    }

    protected void hookControl(Button button) {
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent evt) {
                boolean doContinue = BnPushButtonDecorator.this.executeOperation();
                if (!doContinue) {
                    evt.doit = false;
                }
            }

            public void widgetDefaultSelected(SelectionEvent evt) {
            }
        });
    }

    public IOperationPM getPresentationModel() {
        return this.pModel;
    }

    public void setPresentationModel(IOperationPM pModel) {
        if (this.pModel != null) {
            this.pModel.removePropertyChangeListener(this.listener);
        }
        this.pModel = pModel;
        if (this.pModel != null) {
            this.pModel.addPropertyChangeListener(this.listener);
        }
        this.refreshUI();
    }

    protected void refreshUI() {
        this.refreshText();
        this.refreshEnabled();
        this.refreshTooltip();
    }

    private void refreshText() {
        if (!this.textSetManually) {
            if (this.pModel != null && this.pModel.getTitle() != null) {
                this.button.setText(this.pModel.getTitle());
            } else {
                this.button.setText("");
            }
        }
    }

    protected void refreshEnabled() {
        if (this.pModel != null) {
            this.button.setEnabled(this.pModel.isEnabled());
        } else {
            this.button.setEnabled(false);
        }
    }

    protected void refreshTooltip() {
        if (this.pModel != null) {
            if (!this.pModel.isValid()) {
                this.button.setToolTipText(this.pModel.getValidationState().getMessage());
            } else {
                this.button.setToolTipText(this.pModel.getDescription());
            }
        } else {
            this.button.setToolTipText(null);
        }
    }

    private boolean executeOperation() {
        try {
            if (this.pModel != null) {
                return this.pModel.execute();
            }
        }
        catch (Throwable e) {
            ExceptionUtil.getInstance().handleException("", e);
        }
        return true;
    }

    public void setModelProvider(IModelProvider provider) {
        this.link.setModelProvider(provider);
    }

    public IModelProvider getModelProvider() {
        return this.link.getModelProvider();
    }

    public void setPath(Path path) {
        this.link.setPath(path);
    }

    public Path getPath() {
        return this.link.getPath();
    }

    public Button getButton() {
        return (Button)this.getControl();
    }
}

