/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.beanfabrics.IModelProvider;
import org.beanfabrics.Link;
import org.beanfabrics.ModelSubscriber;
import org.beanfabrics.Path;
import org.beanfabrics.View;
import org.beanfabrics.event.WeakPropertyChangeListener;
import org.beanfabrics.model.ITextPM;
import org.beanfabrics.swt.AbstractDecorator;
import org.beanfabrics.swt.ValidationIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class BnLabelDecorator
extends AbstractDecorator<Label>
implements View<ITextPM>,
ModelSubscriber {
    private final Link link = new Link((View)this);
    private final PropertyChangeListener listener = new WeakPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            BnLabelDecorator.this.refreshUI();
        }
    };
    private ValidationIndicator validationIndicator;
    private ITextPM pModel;
    private Label label;

    public BnLabelDecorator(Label label) {
        super(label);
        this.label = label;
        this.hookControl(label);
    }

    private void hookControl(Label label) {
        Composite parent = label.getParent();
        if (parent instanceof ValidationIndicator) {
            this.setValidationIndicator((ValidationIndicator)parent);
        }
        this.refreshUI();
    }

    public BnLabelDecorator(Composite parent, int style) {
        this(new Label(parent, style));
    }

    public ITextPM getPresentationModel() {
        return this.pModel;
    }

    public void setPresentationModel(ITextPM pModel) {
        if (this.pModel != null) {
            this.pModel.removePropertyChangeListener(this.listener);
        }
        this.pModel = pModel;
        if (this.pModel != null) {
            this.pModel.addPropertyChangeListener(this.listener);
        }
        this.refreshUI();
    }

    protected void refreshUI() {
        this.refreshText();
        this.refreshTooltip();
        this.refreshValidationIndicator();
    }

    protected void refreshText() {
        if (this.pModel != null) {
            if (!this.label.getText().equals(this.pModel.getText())) {
                this.label.setText(this.pModel.getText());
            }
        } else {
            this.label.setText("");
        }
    }

    protected void refreshTooltip() {
        if (this.pModel != null) {
            if (!this.pModel.isValid()) {
                this.label.setToolTipText(this.pModel.getValidationState().getMessage());
            } else {
                this.label.setToolTipText(this.pModel.getDescription());
            }
        } else {
            this.label.setToolTipText(null);
        }
    }

    protected void refreshValidationIndicator() {
        if (this.validationIndicator != null) {
            if (this.pModel != null) {
                this.validationIndicator.setValidationState(this.pModel.getValidationState());
            } else {
                this.validationIndicator.setValidationState(null);
            }
        }
    }

    public void setModelProvider(IModelProvider provider) {
        this.link.setModelProvider(provider);
    }

    public IModelProvider getModelProvider() {
        return this.link.getModelProvider();
    }

    public void setPath(Path path) {
        this.link.setPath(path);
    }

    public Path getPath() {
        return this.link.getPath();
    }

    public ValidationIndicator getValidationIndicator() {
        return this.validationIndicator;
    }

    public void setValidationIndicator(ValidationIndicator validationIndicator) {
        this.validationIndicator = validationIndicator;
    }
}

