/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.beanfabrics.IModelProvider;
import org.beanfabrics.Link;
import org.beanfabrics.ModelSubscriber;
import org.beanfabrics.Path;
import org.beanfabrics.View;
import org.beanfabrics.event.WeakPropertyChangeListener;
import org.beanfabrics.model.ITextPM;
import org.beanfabrics.model.Options;
import org.beanfabrics.swt.AbstractDecorator;
import org.beanfabrics.swt.ValidationIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class BnComboDecorator
extends AbstractDecorator<Combo>
implements View<ITextPM>,
ModelSubscriber {
    private final Link link = new Link((View)this);
    private final PropertyChangeListener listener = new WeakPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            BnComboDecorator.this.refreshUI();
        }
    };
    private final MyModifyListener uiListener = new MyModifyListener();
    private ITextPM pModel;
    private ValidationIndicator validationIndicator;
    private Combo combo;

    public BnComboDecorator(Combo combo) {
        super(combo);
        this.combo = combo;
        this.hookControl(combo);
    }

    public BnComboDecorator(Composite parent, int style) {
        this(new Combo(parent, style));
    }

    protected void hookControl(Combo combo) {
        Composite parent = combo.getParent();
        if (parent instanceof ValidationIndicator) {
            this.setValidationIndicator((ValidationIndicator)parent);
        }
        combo.addModifyListener((ModifyListener)this.uiListener);
        this.refreshUI();
    }

    protected void updateModel() {
        if (this.pModel != null) {
            this.pModel.setText(this.combo.getText());
        }
    }

    public ITextPM getPresentationModel() {
        return this.pModel;
    }

    public void setPresentationModel(ITextPM pModel) {
        if (this.pModel != null) {
            this.pModel.removePropertyChangeListener(this.listener);
        }
        this.pModel = pModel;
        if (this.pModel != null) {
            this.pModel.addPropertyChangeListener(this.listener);
        }
        this.refreshUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshUI() {
        this.uiListener.enabled = false;
        try {
            this.refreshEditable();
            this.refreshOptions();
            this.refreshText();
            this.refreshToolTip();
            this.refreshValidationIndicator();
        }
        finally {
            this.uiListener.enabled = true;
        }
    }

    protected void refreshEditable() {
        if (this.pModel != null) {
            this.combo.setEnabled(this.pModel.isEditable());
        } else {
            this.combo.setEnabled(false);
        }
    }

    protected void refreshValidationIndicator() {
        if (this.validationIndicator != null) {
            if (this.pModel != null) {
                this.validationIndicator.setValidationState(this.pModel.getValidationState());
            } else {
                this.validationIndicator.setValidationState(null);
            }
        }
    }

    protected void refreshToolTip() {
        if (this.pModel != null) {
            if (!this.pModel.isValid()) {
                this.combo.setToolTipText(this.pModel.getValidationState().getMessage());
            } else {
                this.combo.setToolTipText(this.pModel.getDescription());
            }
        } else {
            this.combo.setToolTipText(null);
        }
    }

    protected void refreshText() {
        if (this.pModel != null) {
            String textInModel = this.pModel.getText();
            if (!this.combo.getText().equals(textInModel)) {
                if (this.combo.indexOf(textInModel) == -1) {
                    this.combo.add(textInModel, 0);
                    this.combo.select(0);
                }
                this.combo.setText(textInModel);
            }
        } else {
            this.combo.setText("");
        }
    }

    protected void refreshOptions() {
        if (this.pModel != null) {
            Options opts = this.pModel.getOptions();
            if (opts != null) {
                if (!this.equals(this.combo.getItems(), opts.getValues())) {
                    this.combo.remove(0, this.combo.getItemCount() - 1);
                    for (String value : opts.getValues()) {
                        this.combo.add(value);
                    }
                }
            } else {
                this.combo.removeAll();
            }
        } else {
            this.combo.removeAll();
        }
    }

    private boolean equals(String[] a, String[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (this.equals(a[i], b[i])) continue;
            return false;
        }
        return true;
    }

    private boolean equals(String a, String b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return a.equals(b);
    }

    public void setModelProvider(IModelProvider provider) {
        this.link.setModelProvider(provider);
    }

    public IModelProvider getModelProvider() {
        return this.link.getModelProvider();
    }

    public void setPath(Path path) {
        this.link.setPath(path);
    }

    public Path getPath() {
        return this.link.getPath();
    }

    public ValidationIndicator getValidationIndicator() {
        return this.validationIndicator;
    }

    public void setValidationIndicator(ValidationIndicator validationIndicator) {
        this.validationIndicator = validationIndicator;
    }

    private class MyModifyListener
    implements ModifyListener {
        public boolean enabled = true;

        private MyModifyListener() {
        }

        public void modifyText(ModifyEvent evt) {
            if (this.enabled) {
                BnComboDecorator.this.updateModel();
            }
        }
    }
}

