/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.beanfabrics.IModelProvider;
import org.beanfabrics.Link;
import org.beanfabrics.ModelSubscriber;
import org.beanfabrics.Path;
import org.beanfabrics.View;
import org.beanfabrics.event.WeakPropertyChangeListener;
import org.beanfabrics.model.ConversionException;
import org.beanfabrics.model.IBooleanPM;
import org.beanfabrics.swt.AbstractDecorator;
import org.beanfabrics.swt.ValidationIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class BnButtonDecorator
extends AbstractDecorator<Button>
implements View<IBooleanPM>,
ModelSubscriber {
    private final Link link = new Link((View)this);
    private final PropertyChangeListener listener = new WeakPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            BnButtonDecorator.this.refreshUI();
        }
    };
    private final SelectionListener uiListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent arg0) {
            BnButtonDecorator.this.updateModel();
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }
    };
    private ValidationIndicator validationIndicator;
    private IBooleanPM pModel;
    private Button button;

    public BnButtonDecorator(Button button) {
        super(button);
        this.checkStyle(button.getStyle());
        this.button = button;
        this.hookControl(button);
    }

    private void checkStyle(int style) {
        if ((style & 8) != 0) {
            throw new IllegalArgumentException("Button must not be styled with SWT.PUSH");
        }
    }

    public BnButtonDecorator(Composite parent, int style) {
        this(new Button(parent, style));
    }

    private void hookControl(Button button) {
        Composite parent = button.getParent();
        if (parent instanceof ValidationIndicator) {
            this.setValidationIndicator((ValidationIndicator)parent);
        }
        button.addSelectionListener(this.uiListener);
        this.refreshUI();
    }

    public IBooleanPM getPresentationModel() {
        return this.pModel;
    }

    public void setPresentationModel(IBooleanPM pModel) {
        if (this.pModel != null) {
            this.pModel.removePropertyChangeListener(this.listener);
        }
        this.pModel = pModel;
        if (this.pModel != null) {
            this.pModel.addPropertyChangeListener(this.listener);
        }
        this.refreshUI();
    }

    protected void refreshUI() {
        this.refreshEnabled();
        this.refreshTooltip();
        this.refreshSelection();
        this.refreshValidationIndicator();
    }

    protected void refreshEnabled() {
        if (this.pModel != null) {
            this.button.setEnabled(this.pModel.isEditable());
        } else {
            this.button.setEnabled(false);
        }
    }

    protected void refreshTooltip() {
        if (this.pModel != null) {
            if (!this.pModel.isValid()) {
                this.button.setToolTipText(this.pModel.getValidationState().getMessage());
            } else {
                this.button.setToolTipText(this.pModel.getDescription());
            }
        } else {
            this.button.setToolTipText(null);
        }
    }

    protected void refreshSelection() {
        if (this.pModel != null) {
            try {
                Boolean value = this.pModel.getBoolean();
                this.button.setSelection(value != null && value != false);
            }
            catch (ConversionException conversionException) {}
        } else {
            this.button.setSelection(false);
        }
    }

    protected void refreshValidationIndicator() {
        if (this.validationIndicator != null) {
            if (this.pModel != null) {
                this.validationIndicator.setValidationState(this.pModel.getValidationState());
            } else {
                this.validationIndicator.setValidationState(null);
            }
        }
    }

    protected void updateModel() {
        if (this.pModel != null) {
            this.pModel.setBoolean(Boolean.valueOf(this.button.getSelection()));
        }
    }

    public void setModelProvider(IModelProvider provider) {
        this.link.setModelProvider(provider);
    }

    public IModelProvider getModelProvider() {
        return this.link.getModelProvider();
    }

    public void setPath(Path path) {
        this.link.setPath(path);
    }

    public Path getPath() {
        return this.link.getPath();
    }

    public ValidationIndicator getValidationIndicator() {
        return this.validationIndicator;
    }

    public void setValidationIndicator(ValidationIndicator validationIndicator) {
        this.validationIndicator = validationIndicator;
    }
}

