/*
 * Decompiled with CFR 0.152.
 */
package org.baswell.sessioncookie;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.baswell.sessioncookie.CacheManager;
import org.baswell.sessioncookie.CookieBackedSession;
import org.baswell.sessioncookie.EncodedEncryptedCookieValue;
import org.baswell.sessioncookie.RequestWrapper;
import org.baswell.sessioncookie.SessionCookieErrorHandler;
import org.baswell.sessioncookie.SessionCookieParameters;
import org.baswell.sessioncookie.SessionCookieRequestChain;

public class SessionCookieRequestHandler {
    private final CacheManager cacheManager;
    private final SessionCookieParameters parameters;
    private final SessionCookieErrorHandler errorHandler;

    public SessionCookieRequestHandler(SessionCookieParameters parameters, SessionCookieErrorHandler errorHandler) throws GeneralSecurityException, PatternSyntaxException {
        this.parameters = parameters;
        this.errorHandler = errorHandler;
        this.cacheManager = new CacheManager(parameters, errorHandler);
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, SessionCookieRequestChain chain) throws IOException, ServletException {
        RequestWrapper requestWrapper = new RequestWrapper(request, this.cacheManager);
        chain.forward((HttpServletRequest)requestWrapper, response);
        CookieBackedSession session = requestWrapper.cookieBackedSession;
        if (session == null) {
            if (this.sessionCookieExists(request) && this.parameters.getInactivityTimeoutSeconds() > 0) {
                session = this.cacheManager.getSession(request, false);
                if (session != null) {
                    this.addSessionCookie(session, response);
                } else {
                    this.removeSessionCookie(request, response);
                }
            }
        } else if (session.invalidated) {
            this.removeSessionCookie(request, response);
        } else if (session.sessionChanged || this.parameters.getInactivityTimeoutSeconds() > 0) {
            this.addSessionCookie(session, response);
        }
    }

    private boolean sessionCookieExists(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            String cookieName = this.parameters.getCookieName();
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                return true;
            }
        }
        return false;
    }

    private void addSessionCookie(CookieBackedSession session, HttpServletResponse response) {
        session.touch();
        try {
            String cookieValue = EncodedEncryptedCookieValue.encodeAndEncrypt(session.controlData.encode(), session.sessionData.encode(), this.parameters.getSymmetricEncryptionKey(), this.parameters.getSymmetricEncryptionAlgorithm());
            if (cookieValue.length() >= this.parameters.getCookieSizeWarning()) {
                this.errorHandler.onSessionCookieSizeWarning(session, cookieValue.length());
            }
            Cookie cookie = new Cookie(this.parameters.getCookieName(), cookieValue);
            cookie.setMaxAge(-1);
            String domain = this.parameters.getCookieDomain();
            if (domain != null && !domain.isEmpty()) {
                cookie.setDomain(domain);
            }
            response.addCookie(cookie);
        }
        catch (GeneralSecurityException exception) {
            this.errorHandler.onGeneralSecurityException(exception, this.parameters, true);
        }
    }

    private void removeSessionCookie(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            String cookieName = this.parameters.getCookieName();
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                cookie.setValue(null);
                cookie.setMaxAge(0);
                response.addCookie(cookie);
                break;
            }
        }
    }
}

