/*
 * Decompiled with CFR 0.152.
 */
package org.baswell.sessioncookie;

import java.security.GeneralSecurityException;

public interface SessionCookieParameters {
    public static final int DEFAULT_SESSION_TIMEOUT_MINUTES = 30;
    public static final int DEFAULT_INACTIVITY_TIMEOUT_SECONDS = -1;
    public static final int DEFAULT_MAX_IN_MEMORY_SESSIONS = -1;
    public static final boolean DEFAULT_PURGE_SESSION_CACHE_WITH_BACKGROUND_THREAD = false;
    public static final int DEFAULT_MINIMUM_SECONDS_BETWEEN_SESSION_CACHE_PURGES = 15;
    public static final String DEFAULT_SYMMETRIC_ENCRYPTION_ALGORITHM = "AES";
    public static final String DEFAULT_COOKIE_DOMAIN = null;
    public static final String DEFAULT_COOKIE_NAME = "org.baswell.sessioncookie";
    public static final int DEFAULT_COOKIE_SIZE_WARNING = 4096;

    default public int getSessionTimeoutMinutes() {
        return 30;
    }

    default public int getInactivityTimeoutSeconds() {
        return -1;
    }

    default public int getMaxInMemorySessions() {
        return -1;
    }

    default public boolean getPurgeSessionCacheWithBackgroundThread() {
        return false;
    }

    default public int getMinimumSecondsBetweenSessionCachePurges() {
        return 15;
    }

    default public String getSymmetricEncryptionAlgorithm() {
        return DEFAULT_SYMMETRIC_ENCRYPTION_ALGORITHM;
    }

    public byte[] getSymmetricEncryptionKey() throws GeneralSecurityException;

    default public String getCookieDomain() {
        return DEFAULT_COOKIE_DOMAIN;
    }

    default public String getCookieName() {
        return DEFAULT_COOKIE_NAME;
    }

    default public int getCookieSizeWarning() {
        return 4096;
    }
}

