/*
 * Decompiled with CFR 0.152.
 */
package org.baswell.sessioncookie;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.baswell.sessioncookie.EncodedEncryptedCookieValue;
import org.baswell.sessioncookie.SessionCookieDefaultErrorHandler;
import org.baswell.sessioncookie.SessionCookieDefaultParameters;
import org.baswell.sessioncookie.SessionCookieErrorHandler;
import org.baswell.sessioncookie.SessionCookieFilterRequestChain;
import org.baswell.sessioncookie.SessionCookieParameters;
import org.baswell.sessioncookie.SessionCookieRequestHandler;
import org.baswell.sessioncookie.SharedMethods;

public class SessionCookieFilter
implements Filter {
    static final String PARAMETERS_CLASS_NAME = "SessionCookieParametersClassName";
    static final String ERROR_HANDLER_CLASS_NAME = "SessionCookieErrorHandlerClassName";
    static final String SESSION_TIMEOUT_MINUTES = "SessionTimeoutMinutes";
    static final String INACTIVITY_TIMEOUT_SECONDS = "InactivityTimeoutSeconds";
    static final String MAX_IN_MEMORY_SESSIONS = "MaxInMemorySessions";
    static final String PURGE_SESSION_CACHE_WITH_BACKGROUND_THREAD = "PurgeSessionCacheWithBackgroundThread";
    static final String MINIMUM_SECONDS_BETWEEN_SESSION_CACHE_PURGES = "MinimumSecondsBetweenSessionCachePurge";
    static final String SYMMETRIC_ENCRYPTION_ALGORITHM = "SymmetricEncryptionAlgorithm";
    static final String SYMMETRIC_ENCRYPTION_KEY = "SymmetricEncryptionKey";
    static final String COOKIE_DOMAIN = "CookieDomain";
    static final String COOKIE_NAME = "CookieName";
    static final String COOKIE_SIZE_WARNING = "CookieSizeWarning";
    static final String ONLY_PATHS = "OnlyPaths";
    static final String EXCLUDED_PATHS = "ExcludedPaths";
    private List<Pattern> includedPaths;
    private List<Pattern> excludedPaths;
    private SessionCookieRequestHandler processor;

    public void init(FilterConfig filterConfig) throws ServletException {
        SessionCookieParameters parameters = null;
        SessionCookieErrorHandler errorHandler = null;
        String parametersClassName = filterConfig.getInitParameter(PARAMETERS_CLASS_NAME);
        if (SharedMethods.hasContent(parametersClassName)) {
            try {
                Class<?> clazz = Class.forName(parametersClassName);
                parameters = (SessionCookieParameters)clazz.newInstance();
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new ServletException(String.format("Invalid %s parameter %s.", PARAMETERS_CLASS_NAME, parametersClassName), (Throwable)e);
            }
        }
        String errorHandlerClassName = filterConfig.getInitParameter(ERROR_HANDLER_CLASS_NAME);
        if (SharedMethods.hasContent(parametersClassName)) {
            try {
                Class<?> clazz = Class.forName(errorHandlerClassName);
                errorHandler = (SessionCookieErrorHandler)clazz.newInstance();
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new ServletException(String.format("Invalid %s parameter %s.", ERROR_HANDLER_CLASS_NAME, errorHandlerClassName), (Throwable)e);
            }
        }
        if (parameters == null) {
            String cookieSizeWarning;
            String cookieName;
            String cookieDomain;
            String encryptionKeyParameter;
            String encryptionSymmetricAlgorithm;
            String cleanPollSecondsParam;
            String useBackgroundThread;
            String maxInMemorySessionsParam;
            String[] inactivityTimeoutSecondsParam;
            SessionCookieDefaultParameters defaultParmaters = new SessionCookieDefaultParameters();
            parameters = defaultParmaters;
            String sessionTimeoutMinutesParam = filterConfig.getInitParameter(SESSION_TIMEOUT_MINUTES);
            if (SharedMethods.hasContent(sessionTimeoutMinutesParam)) {
                defaultParmaters.setSessionTimeoutMinutes(SessionCookieFilter.parseParameter(SESSION_TIMEOUT_MINUTES, sessionTimeoutMinutesParam));
            }
            if (SharedMethods.hasContent((String)(inactivityTimeoutSecondsParam = filterConfig.getInitParameter(INACTIVITY_TIMEOUT_SECONDS)))) {
                defaultParmaters.setInactivityTimeoutSeconds(SessionCookieFilter.parseParameter(INACTIVITY_TIMEOUT_SECONDS, (String)inactivityTimeoutSecondsParam));
            }
            if (SharedMethods.hasContent(maxInMemorySessionsParam = filterConfig.getInitParameter(MAX_IN_MEMORY_SESSIONS))) {
                defaultParmaters.setMaxInMemorySessions(SessionCookieFilter.parseParameter(MAX_IN_MEMORY_SESSIONS, maxInMemorySessionsParam));
            }
            if (SharedMethods.hasContent(useBackgroundThread = filterConfig.getInitParameter(PURGE_SESSION_CACHE_WITH_BACKGROUND_THREAD))) {
                defaultParmaters.setPurgeSessionCacheWithBackgroundThread(Boolean.parseBoolean(useBackgroundThread));
            }
            if (SharedMethods.hasContent(cleanPollSecondsParam = filterConfig.getInitParameter(MINIMUM_SECONDS_BETWEEN_SESSION_CACHE_PURGES))) {
                defaultParmaters.setMinimumSecondsBetweenSessionCachePurges(SessionCookieFilter.parseParameter(MINIMUM_SECONDS_BETWEEN_SESSION_CACHE_PURGES, cleanPollSecondsParam));
            }
            if (SharedMethods.hasContent(encryptionSymmetricAlgorithm = filterConfig.getInitParameter(SYMMETRIC_ENCRYPTION_ALGORITHM))) {
                defaultParmaters.setSymmetricEncryptionAlgorithm(encryptionSymmetricAlgorithm);
            }
            if (SharedMethods.hasContent(encryptionKeyParameter = filterConfig.getInitParameter(SYMMETRIC_ENCRYPTION_KEY))) {
                try {
                    defaultParmaters.setSymmetricEncryptionKey(Base64.getDecoder().decode(encryptionKeyParameter));
                }
                catch (Exception e) {
                    throw new ServletException(String.format("Invalid %s parameter %s.", SYMMETRIC_ENCRYPTION_KEY, encryptionKeyParameter), (Throwable)e);
                }
            }
            if (SharedMethods.hasContent(cookieDomain = filterConfig.getInitParameter(COOKIE_DOMAIN))) {
                defaultParmaters.setCookieDomain(cookieDomain);
            }
            if (SharedMethods.hasContent(cookieName = filterConfig.getInitParameter(COOKIE_NAME))) {
                defaultParmaters.setCookieName(cookieName);
            }
            if (SharedMethods.hasContent(cookieSizeWarning = filterConfig.getInitParameter(COOKIE_SIZE_WARNING))) {
                defaultParmaters.setCookieSizeWarning(SessionCookieFilter.parseParameter(COOKIE_SIZE_WARNING, cookieSizeWarning));
            }
        }
        try {
            EncodedEncryptedCookieValue.encodeAndEncrypt("A", "B", parameters.getSymmetricEncryptionKey(), parameters.getSymmetricEncryptionAlgorithm());
        }
        catch (Exception e) {
            throw new ServletException(String.format("Unable to encrypt using provided algorithm %s and key.", parameters.getSymmetricEncryptionAlgorithm()), (Throwable)e);
        }
        if (errorHandler == null) {
            errorHandler = new SessionCookieDefaultErrorHandler();
        }
        this.includedPaths = null;
        String includedPathsParams = filterConfig.getInitParameter(ONLY_PATHS);
        if (SharedMethods.hasContent(includedPathsParams)) {
            String[] paths;
            this.includedPaths = new ArrayList<Pattern>();
            for (String path : paths = includedPathsParams.split(",")) {
                if (!SharedMethods.hasContent(path)) continue;
                try {
                    this.includedPaths.add(Pattern.compile(path));
                }
                catch (Exception e) {
                    throw new ServletException(String.format("Invalid included paths pattern %s for parameter %s.", path, includedPathsParams), (Throwable)e);
                }
            }
        }
        this.excludedPaths = null;
        String excludedPathsParams = filterConfig.getInitParameter(EXCLUDED_PATHS);
        if (SharedMethods.hasContent(includedPathsParams)) {
            String[] paths;
            this.excludedPaths = new ArrayList<Pattern>();
            for (String path : paths = excludedPathsParams.split(",")) {
                if (!SharedMethods.hasContent(path)) continue;
                try {
                    this.excludedPaths.add(Pattern.compile(path));
                }
                catch (Exception e) {
                    throw new ServletException(String.format("Invalid excluded paths pattern %s for parameter %s.", path, excludedPathsParams), (Throwable)e);
                }
            }
        }
        try {
            this.processor = new SessionCookieRequestHandler(parameters, errorHandler);
        }
        catch (GeneralSecurityException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        if (SessionCookieFilter.wrapRequest(httpRequest.getContextPath(), httpRequest.getRequestURI(), this.includedPaths, this.excludedPaths)) {
            this.processor.handle(httpRequest, (HttpServletResponse)servletResponse, new SessionCookieFilterRequestChain(filterChain));
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
    }

    static int parseParameter(String parameterName, String parameterValue) throws ServletException {
        try {
            return Integer.parseInt(parameterValue);
        }
        catch (NumberFormatException e) {
            throw new ServletException(String.format("Invalid %s parameter %s.", parameterName, parameterValue), (Throwable)e);
        }
    }

    static boolean wrapRequest(String contextPath, String requestPath, List<Pattern> onlyPatterns, List<Pattern> exceptPatterns) {
        if (requestPath.startsWith(contextPath)) {
            requestPath = requestPath.substring(contextPath.length(), requestPath.length());
        }
        if (onlyPatterns != null || exceptPatterns != null) {
            if (onlyPatterns != null) {
                boolean matchFound = false;
                for (Pattern onlyPattern : onlyPatterns) {
                    if (!onlyPattern.matcher(requestPath).matches()) continue;
                    matchFound = true;
                    break;
                }
                if (!matchFound) {
                    return false;
                }
            }
            if (exceptPatterns != null) {
                for (Pattern exceptPattern : exceptPatterns) {
                    if (!exceptPattern.matcher(requestPath).matches()) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

