/*
 * Decompiled with CFR 0.152.
 */
package org.baswell.sessioncookie;

import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.UnknownFormatConversionException;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.baswell.sessioncookie.SessionCookieDecodingException;
import org.baswell.sessioncookie.SessionCookieDecryptionException;

class EncodedEncryptedCookieValue {
    final String controlData;
    final String sessionData;
    static final String DELIMITER = ",";

    static EncodedEncryptedCookieValue decodeAndDecrypt(String encodedEncryptedValue, byte[] key, String algorithm) throws GeneralSecurityException, SessionCookieDecryptionException, SessionCookieDecodingException {
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(2, new SecretKeySpec(key, algorithm));
        try {
            String data = new String(cipher.doFinal(Base64.getDecoder().decode(encodedEncryptedValue)));
            String[] split = data.split(DELIMITER);
            if (split.length != 2) {
                throw new SessionCookieDecodingException(String.format("Invalid number of sections %i in cookie value %s.", split.length, data), data);
            }
            return new EncodedEncryptedCookieValue(split[0], split[1]);
        }
        catch (UnknownFormatConversionException e) {
            throw new SessionCookieDecodingException(String.format("Invalid Base64 encoded cookie value.", new Object[0]), encodedEncryptedValue, e);
        }
        catch (GeneralSecurityException e) {
            throw new SessionCookieDecryptionException(key, algorithm, encodedEncryptedValue.getBytes(), e);
        }
    }

    static String encodeAndEncrypt(String controlData, String sessionData, byte[] key, String algorithm) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(1, new SecretKeySpec(key, algorithm));
        byte[] data = (controlData + DELIMITER + sessionData).getBytes();
        return Base64.getEncoder().encodeToString(cipher.doFinal(data));
    }

    public EncodedEncryptedCookieValue(String controlData, String sessionData) {
        this.controlData = controlData;
        this.sessionData = sessionData;
    }
}

