/*
 * Decompiled with CFR 0.152.
 */
package org.baswell.sessioncookie;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.UUID;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.baswell.sessioncookie.EncodedMap;

class CookieBackedSession
implements HttpSession {
    static final String SESSION_ID_KEY = "sessionId";
    static final String CREATED_AT_KEY = "createdAt";
    static final String LAST_ACCESSED_AT_KEY = "lastAccessedAt";
    static final String SESSION_INACTIVITY_TIMEOUT_KEY = "sessionInactivityTimeout";
    EncodedMap controlData;
    EncodedMap sessionData;
    HttpServletRequest currentRequest;
    boolean newSession;
    boolean sessionChanged;
    boolean invalidated;

    CookieBackedSession(int sessionInactivityTimeoutSeconds) {
        this.newSession = true;
        this.controlData = new EncodedMap();
        this.sessionData = new EncodedMap();
        this.controlData.put(SESSION_ID_KEY, UUID.randomUUID().toString());
        long now = System.currentTimeMillis();
        this.controlData.put(CREATED_AT_KEY, now);
        this.controlData.put(LAST_ACCESSED_AT_KEY, now);
        this.controlData.put(SESSION_INACTIVITY_TIMEOUT_KEY, sessionInactivityTimeoutSeconds);
    }

    CookieBackedSession(EncodedMap controlData, EncodedMap sessionData) {
        this.controlData = controlData;
        this.sessionData = sessionData;
    }

    boolean hasExpired(int maxSessionMinutes) {
        int minutesSinceCreated = (int)(System.currentTimeMillis() - this.getCreationTime()) / 1000 / 60;
        if (minutesSinceCreated > maxSessionMinutes) {
            return true;
        }
        int maxInactivitySeconds = this.getMaxInactiveInterval();
        if (maxInactivitySeconds >= 0) {
            int secondsSinceLastActivity = (int)(System.currentTimeMillis() - this.getLastAccessedAt()) / 1000;
            return secondsSinceLastActivity > maxInactivitySeconds;
        }
        return false;
    }

    long getLastAccessedAt() {
        return (Long)this.controlData.get(LAST_ACCESSED_AT_KEY);
    }

    void update(HttpServletRequest currentRequest) {
        this.currentRequest = currentRequest;
    }

    void update(HttpServletRequest currentRequest, EncodedMap controlData, EncodedMap sessionData) {
        this.update(currentRequest);
        this.controlData = controlData;
        this.sessionData = sessionData;
    }

    void touch() {
        this.controlData.put(LAST_ACCESSED_AT_KEY, System.currentTimeMillis());
    }

    public String getId() {
        return (String)this.controlData.get(SESSION_ID_KEY);
    }

    public long getCreationTime() {
        return (Long)this.controlData.get(CREATED_AT_KEY);
    }

    public long getLastAccessedTime() {
        return (Long)this.controlData.get(LAST_ACCESSED_AT_KEY);
    }

    public Object getAttribute(String name) {
        this.assertValid();
        return this.sessionData.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.assertValid();
        if (!(value instanceof Serializable)) {
            throw new IllegalArgumentException(String.format("HttpSession.setAttribute called with name %s and non-Serializable value of type %s. Only values of type Serializable are allowed.", name, value.getClass().toString()));
        }
        this.sessionChanged = true;
        this.sessionData.put(name, value);
    }

    public void removeAttribute(String name) {
        this.assertValid();
        if (this.sessionData.containsKey(name)) {
            this.sessionChanged = true;
            this.sessionData.remove(name);
        }
    }

    public Enumeration<String> getAttributeNames() {
        this.assertValid();
        return new Vector(this.sessionData.keySet()).elements();
    }

    public int getMaxInactiveInterval() {
        return (Integer)this.controlData.get(SESSION_INACTIVITY_TIMEOUT_KEY);
    }

    public void setMaxInactiveInterval(int interval) {
        this.controlData.put(SESSION_INACTIVITY_TIMEOUT_KEY, interval);
    }

    public ServletContext getServletContext() {
        return this.currentRequest.getServletContext();
    }

    public HttpSessionContext getSessionContext() {
        throw new IllegalStateException("HttpSession.getSessionContext is not supported.");
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public String[] getValueNames() {
        Enumeration<String> names = this.getAttributeNames();
        ArrayList<String> list = new ArrayList<String>();
        while (names.hasMoreElements()) {
            list.add(names.nextElement());
        }
        return list.toArray(new String[list.size()]);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void invalidate() {
        this.invalidated = true;
        this.sessionData.clear();
    }

    public boolean isNew() {
        return this.newSession;
    }

    void assertValid() {
        if (this.invalidated) {
            throw new IllegalStateException("This session has been invalidated.");
        }
    }
}

