/*
 * Decompiled with CFR 0.152.
 */
package org.baswell.sessioncookie;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.baswell.sessioncookie.CookieBackedSession;
import org.baswell.sessioncookie.EncodedEncryptedCookieValue;
import org.baswell.sessioncookie.EncodedMap;
import org.baswell.sessioncookie.SessionCookieDecodingException;
import org.baswell.sessioncookie.SessionCookieDecryptionException;
import org.baswell.sessioncookie.SessionCookieErrorHandler;
import org.baswell.sessioncookie.SessionCookieParameters;

class CacheManager
implements Runnable {
    private final SessionCookieParameters parameters;
    private final SessionCookieErrorHandler errorHandler;
    private final Map<String, CookieBackedSession> cache = new ConcurrentHashMap<String, CookieBackedSession>();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
    private volatile Thread backgroundThread;
    private long lastCleanedAt;
    private volatile boolean cleaning;

    public CacheManager(SessionCookieParameters parameters, SessionCookieErrorHandler errorHandler) {
        this.parameters = parameters;
        this.errorHandler = errorHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CookieBackedSession getSession(HttpServletRequest request, boolean createNewIfNecessary) {
        boolean usePool;
        block27: {
            usePool = this.useCache();
            if (usePool) {
                if (this.parameters.getPurgeSessionCacheWithBackgroundThread()) {
                    this.startIfNecessary();
                } else {
                    this.purgeIfNecessary();
                }
            }
            String cookieValue = null;
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                String cookieName = this.parameters.getCookieName();
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equalsIgnoreCase(cookieName)) continue;
                    cookieValue = cookie.getValue();
                    break;
                }
            }
            if (cookieValue != null) {
                this.readLock.lock();
                try {
                    EncodedEncryptedCookieValue encodedEncryptedCookieValue = EncodedEncryptedCookieValue.decodeAndDecrypt(cookieValue, this.parameters.getSymmetricEncryptionKey(), this.parameters.getSymmetricEncryptionAlgorithm());
                    try {
                        EncodedMap controlData = new EncodedMap(encodedEncryptedCookieValue.controlData);
                        try {
                            CookieBackedSession session;
                            if (usePool) {
                                String sessionId = (String)controlData.get("sessionId");
                                session = this.cache.get(sessionId);
                                if (session == null) {
                                    session = new CookieBackedSession(controlData, new EncodedMap(encodedEncryptedCookieValue.sessionData));
                                }
                            } else {
                                session = new CookieBackedSession(controlData, new EncodedMap(encodedEncryptedCookieValue.sessionData));
                            }
                            if (session.hasExpired(this.parameters.getSessionTimeoutMinutes())) {
                                session = null;
                                if (usePool) {
                                    this.cache.remove(session.getId());
                                }
                                break block27;
                            }
                            if (usePool && !this.cache.containsKey(session.getId())) {
                                this.cache.put(session.getId(), session);
                            }
                            CookieBackedSession cookieBackedSession = session;
                            return cookieBackedSession;
                        }
                        catch (ClassNotFoundException exception) {
                            this.errorHandler.onClassNotFoundFromSessionException(exception);
                        }
                    }
                    catch (ClassNotFoundException exception) {
                        throw new RuntimeException(exception);
                    }
                }
                catch (GeneralSecurityException e) {
                    this.errorHandler.onGeneralSecurityException(e, this.parameters, false);
                }
                catch (SessionCookieDecryptionException e) {
                    this.errorHandler.onCookieDecryptError(e);
                }
                catch (SessionCookieDecodingException e) {
                    this.errorHandler.onCookieDecodeError(e);
                }
                finally {
                    this.readLock.unlock();
                }
            }
        }
        if (!createNewIfNecessary) return null;
        CookieBackedSession session = new CookieBackedSession(this.parameters.getInactivityTimeoutSeconds());
        if (!usePool) return session;
        this.cache.put(session.getId(), session);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void purgeIfNecessary() {
        int secondsSinceLastClean = (int)((System.currentTimeMillis() - this.lastCleanedAt) / 1000L);
        if (!this.cleaning && secondsSinceLastClean < this.parameters.getMinimumSecondsBetweenSessionCachePurges()) {
            boolean clean = false;
            CacheManager cacheManager = this;
            synchronized (cacheManager) {
                if (!this.cleaning && secondsSinceLastClean < this.parameters.getMinimumSecondsBetweenSessionCachePurges()) {
                    this.cleaning = true;
                    clean = true;
                }
            }
            if (clean) {
                try {
                    this.purge();
                }
                finally {
                    this.cleaning = false;
                    this.lastCleanedAt = System.currentTimeMillis();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void purge() {
        if (!this.useCache()) {
            if (!this.cache.isEmpty()) {
                this.writeLock.lock();
                try {
                    this.cache.clear();
                }
                finally {
                    this.writeLock.unlock();
                }
            }
        } else {
            int numberSessionsToRemove;
            ArrayList<String> expiredSessionIds = new ArrayList<String>();
            int maxSessionMinutes = this.parameters.getSessionTimeoutMinutes();
            for (CookieBackedSession session : this.cache.values()) {
                if (!session.hasExpired(maxSessionMinutes)) continue;
                expiredSessionIds.add(session.getId());
            }
            this.writeLock.lock();
            try {
                for (String expiredSessionId : expiredSessionIds) {
                    this.cache.remove(expiredSessionId);
                }
            }
            finally {
                this.writeLock.unlock();
            }
            int maxSize = this.parameters.getMaxInMemorySessions();
            if (maxSize >= 0 && (numberSessionsToRemove = this.cache.size() - maxSize) > 0) {
                ArrayList<CookieBackedSession> sessionsToRemove = new ArrayList<CookieBackedSession>();
                block11: for (CookieBackedSession session : this.cache.values()) {
                    if (sessionsToRemove.size() < numberSessionsToRemove) {
                        sessionsToRemove.add(session);
                        continue;
                    }
                    for (int i = 0; i < sessionsToRemove.size(); ++i) {
                        if (((CookieBackedSession)sessionsToRemove.get(i)).getLastAccessedAt() <= session.getLastAccessedAt()) continue;
                        sessionsToRemove.set(i, session);
                        continue block11;
                    }
                }
                this.writeLock.lock();
                try {
                    for (CookieBackedSession session : sessionsToRemove) {
                        this.cache.remove(session.getId());
                    }
                }
                finally {
                    this.writeLock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startIfNecessary() {
        if (this.useCache() && this.backgroundThread == null) {
            CacheManager cacheManager = this;
            synchronized (cacheManager) {
                if (this.backgroundThread == null && !this.backgroundThread.isAlive()) {
                    this.backgroundThread = new Thread((Runnable)this, "SessionCookie Session Cleander");
                    this.backgroundThread.start();
                }
            }
        }
    }

    boolean useCache() {
        return this.parameters.getMaxInMemorySessions() > 0;
    }

    @Override
    public void run() {
        while (this.backgroundThread == Thread.currentThread() && this.parameters.getPurgeSessionCacheWithBackgroundThread() && this.useCache()) {
            this.purge();
            try {
                Thread.sleep((long)this.parameters.getMinimumSecondsBetweenSessionCachePurges() * 1000L);
            }
            catch (Exception exception) {}
        }
    }
}

