/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper.fields;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.Random;
import java.util.StringJoiner;
import java.util.UUID;
import org.basepom.mojo.propertyhelper.Field;
import org.basepom.mojo.propertyhelper.FieldContext;
import org.basepom.mojo.propertyhelper.ValueProvider;
import org.basepom.mojo.propertyhelper.definitions.UuidDefinition;

public final class UuidField
extends Field<String, UuidDefinition> {
    private final ValueProvider valueProvider;
    private final Random secureRandom;

    @VisibleForTesting
    public static UuidField forTesting(UuidDefinition uuidDefinition, ValueProvider valueProvider) {
        return new UuidField(uuidDefinition, valueProvider, FieldContext.forTesting());
    }

    public UuidField(UuidDefinition uuidDefinition, ValueProvider valueProvider, FieldContext fieldContext) {
        super(uuidDefinition, fieldContext);
        this.valueProvider = (ValueProvider)Preconditions.checkNotNull((Object)valueProvider, (Object)"valueProvider is null");
        this.secureRandom = fieldContext.getRandom();
    }

    @Override
    public String getFieldName() {
        return ((UuidDefinition)this.fieldDefinition).getId();
    }

    @Override
    public String getValue() {
        Optional<String> propValue = this.valueProvider.getValue();
        UUID result = propValue.map(UUID::fromString).orElse(((UuidDefinition)this.fieldDefinition).getValue().orElseGet(this::createRandomUUID));
        this.valueProvider.setValue(result.toString());
        return this.formatResult(result.toString());
    }

    private UUID createRandomUUID() {
        long upperValue = this.secureRandom.nextLong();
        long lowerValue = this.secureRandom.nextLong();
        lowerValue &= 0xFF0FFFFFFFFFFFFFL;
        upperValue &= 0xFFFFFFFFFFFFFF3FL;
        return new UUID(upperValue |= 0x80L, lowerValue |= 0x40000000000000L);
    }

    public String toString() {
        return new StringJoiner(", ", UuidField.class.getSimpleName() + "[", "]").add("uuidDefinition=" + this.fieldDefinition).add("valueProvider=" + this.valueProvider).toString();
    }
}

