/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper.fields;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import org.basepom.mojo.propertyhelper.Field;
import org.basepom.mojo.propertyhelper.FieldContext;
import org.basepom.mojo.propertyhelper.IgnoreWarnFail;
import org.basepom.mojo.propertyhelper.ValueProvider;
import org.basepom.mojo.propertyhelper.definitions.StringDefinition;

public final class StringField
extends Field<String, StringDefinition> {
    private final ValueProvider valueProvider;

    @VisibleForTesting
    public static StringField forTesting(StringDefinition stringDefinition, ValueProvider valueProvider) {
        return new StringField(stringDefinition, valueProvider, FieldContext.forTesting());
    }

    public StringField(StringDefinition stringDefinition, ValueProvider valueProvider, FieldContext fieldContext) {
        super(stringDefinition, fieldContext);
        this.valueProvider = valueProvider;
    }

    @Override
    public String getFieldName() {
        return ((StringDefinition)this.fieldDefinition).getId();
    }

    @Override
    public String getValue() {
        ArrayList values = Lists.newArrayList();
        Optional<String> propValue = this.valueProvider.getValue();
        List<String> definedValues = ((StringDefinition)this.fieldDefinition).getValues();
        propValue.ifPresent(values::add);
        values.addAll(definedValues);
        for (String value : values) {
            String stringResult = Strings.nullToEmpty((String)value);
            if (!((StringDefinition)this.fieldDefinition).isBlankIsValid() && stringResult.isBlank()) continue;
            return this.formatResult(value);
        }
        IgnoreWarnFail.checkIgnoreWarnFailState(false, ((StringDefinition)this.fieldDefinition).getOnMissingValue(), () -> "", () -> String.format("No value for string field %s found, using an empty value!", this.getFieldName()));
        return "";
    }

    public String toString() {
        return new StringJoiner(", ", StringField.class.getSimpleName() + "[", "]").add("stringDefinition=" + this.fieldDefinition).add("valueProvider=" + this.valueProvider).toString();
    }
}

