/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper.fields;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.StringJoiner;
import org.apache.maven.plugin.MojoExecutionException;
import org.basepom.mojo.propertyhelper.Field;
import org.basepom.mojo.propertyhelper.FieldContext;
import org.basepom.mojo.propertyhelper.ValueProvider;
import org.basepom.mojo.propertyhelper.definitions.MacroDefinition;
import org.basepom.mojo.propertyhelper.macros.MacroType;

public final class MacroField
extends Field<String, MacroDefinition> {
    private final ValueProvider valueProvider;
    private final FieldContext context;

    @VisibleForTesting
    public static MacroField forTesting(MacroDefinition dateDefinition, ValueProvider valueProvider, FieldContext fieldContext) {
        return new MacroField(dateDefinition, valueProvider, fieldContext);
    }

    public MacroField(MacroDefinition macroDefinition, ValueProvider valueProvider, FieldContext context) {
        super(macroDefinition, context);
        this.valueProvider = valueProvider;
        this.context = context;
    }

    @Override
    public String getFieldName() {
        return ((MacroDefinition)this.fieldDefinition).getId();
    }

    @Override
    public String getValue() throws MojoExecutionException {
        Optional<String> type = ((MacroDefinition)this.fieldDefinition).getMacroType();
        try {
            MacroType macroType;
            if (type.isPresent()) {
                macroType = this.context.getMacros().get(type.get());
                Preconditions.checkState((macroType != null ? 1 : 0) != 0, (String)"Could not locate macro '%s'", (Object)type.get());
            } else {
                Optional<String> macroClassName = ((MacroDefinition)this.fieldDefinition).getMacroClass();
                Preconditions.checkState((boolean)macroClassName.isPresent(), (String)"No definition for macro '%s' found!", (Object)((MacroDefinition)this.fieldDefinition).getId());
                Class<?> macroClass = Class.forName(macroClassName.get());
                macroType = (MacroType)macroClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return this.formatResult(macroType.getValue((MacroDefinition)this.fieldDefinition, this.valueProvider, this.context).orElse(null));
        }
        catch (ReflectiveOperationException e) {
            throw new MojoExecutionException(String.format("Could not instantiate '%s'", this.fieldDefinition), (Exception)e);
        }
    }

    public String toString() {
        return new StringJoiner(", ", MacroField.class.getSimpleName() + "[", "]").add("valueProvider=" + this.valueProvider).add("context=" + this.context).toString();
    }
}

