/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper.definitions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import org.basepom.mojo.propertyhelper.FieldContext;
import org.basepom.mojo.propertyhelper.ValueCache;
import org.basepom.mojo.propertyhelper.ValueProvider;
import org.basepom.mojo.propertyhelper.definitions.FieldDefinition;
import org.basepom.mojo.propertyhelper.fields.UuidField;

public class UuidDefinition
extends FieldDefinition<String> {
    String value = null;

    public UuidDefinition() {
    }

    @VisibleForTesting
    UuidDefinition(String id) {
        super(id);
    }

    public Optional<UUID> getValue() {
        return Optional.ofNullable(this.value).map(UUID::fromString);
    }

    @Override
    public UuidField createField(FieldContext context, ValueCache valueCache) throws IOException {
        Preconditions.checkNotNull((Object)context, (Object)"context is null");
        Preconditions.checkNotNull((Object)valueCache, (Object)"valueCache is null");
        this.check();
        ValueProvider uuidValue = valueCache.getValueProvider(this);
        return new UuidField(this, uuidValue, context);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", UuidDefinition.class.getSimpleName() + "[", "]").add("value='" + this.value + "'").add(super.toString()).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UuidDefinition that = (UuidDefinition)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }
}

