/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper.definitions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Set;
import org.basepom.mojo.propertyhelper.FieldContext;
import org.basepom.mojo.propertyhelper.IgnoreWarnFail;
import org.basepom.mojo.propertyhelper.definitions.PropertyDefinition;
import org.basepom.mojo.propertyhelper.groups.PropertyGroup;

public class PropertyGroupDefinition {
    String id;
    boolean activeOnRelease = true;
    boolean activeOnSnapshot = true;
    private IgnoreWarnFail onDuplicateProperty = IgnoreWarnFail.FAIL;
    private IgnoreWarnFail onMissingField = IgnoreWarnFail.FAIL;
    Set<PropertyDefinition> propertyDefinitions = Set.of();

    public void setOnDuplicateProperty(String onDuplicateProperty) {
        this.onDuplicateProperty = IgnoreWarnFail.forString(onDuplicateProperty);
    }

    public void setOnMissingField(String onMissingField) {
        this.onMissingField = IgnoreWarnFail.forString(onMissingField);
    }

    public void setProperties(PropertyDefinition ... propertyDefinitions) {
        this.propertyDefinitions = ImmutableSet.copyOf(Arrays.asList(propertyDefinitions));
        this.propertyDefinitions.forEach(PropertyDefinition::check);
    }

    public PropertyGroupDefinition() {
    }

    @VisibleForTesting
    PropertyGroupDefinition(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public boolean isActiveOnRelease() {
        return this.activeOnRelease;
    }

    public boolean isActiveOnSnapshot() {
        return this.activeOnSnapshot;
    }

    public IgnoreWarnFail getOnDuplicateProperty() {
        return this.onDuplicateProperty;
    }

    public IgnoreWarnFail getOnMissingField() {
        return this.onMissingField;
    }

    public Set<PropertyDefinition> getPropertyDefinitions() {
        return this.propertyDefinitions;
    }

    public PropertyGroup createGroup(FieldContext context) {
        return new PropertyGroup(this, context);
    }

    public Set<String> getPropertyNames() {
        return (Set)this.propertyDefinitions.stream().map(PropertyDefinition::getName).collect(ImmutableSet.toImmutableSet());
    }
}

