/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper.definitions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public class PropertyDefinition {
    String name = null;
    String value = null;
    private List<String> transformers = List.of();

    public void setTransformers(String transformers) {
        this.transformers = Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)transformers);
    }

    @VisibleForTesting
    PropertyDefinition(String name, String value) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.value = (String)Preconditions.checkNotNull((Object)value, (Object)"value is null");
    }

    public PropertyDefinition() {
    }

    public void check() {
        Preconditions.checkNotNull((Object)this.name, (Object)"property name is null");
        Preconditions.checkNotNull((Object)this.value, (Object)"property value is null");
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public List<String> getTransformers() {
        return this.transformers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyDefinition that = (PropertyDefinition)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.transformers, that.transformers);
    }

    public String toString() {
        return new StringJoiner(", ", PropertyDefinition.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("value='" + this.value + "'").add("transformers='" + this.transformers + "'").toString();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.transformers);
    }
}

