/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper.definitions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basepom.mojo.propertyhelper.Field;
import org.basepom.mojo.propertyhelper.FieldContext;
import org.basepom.mojo.propertyhelper.IgnoreWarnFail;
import org.basepom.mojo.propertyhelper.IgnoreWarnFailCreate;
import org.basepom.mojo.propertyhelper.ValueCache;

public abstract class FieldDefinition<T> {
    String id = null;
    boolean skip = false;
    boolean export = false;
    String propertyNameInFile = null;
    File propertyFile = null;
    private IgnoreWarnFailCreate onMissingFile = IgnoreWarnFailCreate.FAIL;
    private IgnoreWarnFailCreate onMissingFileProperty = IgnoreWarnFailCreate.FAIL;
    private IgnoreWarnFail onMissingProperty = IgnoreWarnFail.FAIL;
    String initialValue = null;
    private Pattern regexp = null;
    String format = null;
    private List<String> transformers = List.of();

    protected FieldDefinition() {
    }

    @VisibleForTesting
    protected FieldDefinition(String id) {
        this.id = id;
    }

    public void setOnMissingFile(String onMissingFile) {
        this.onMissingFile = IgnoreWarnFailCreate.forString(onMissingFile);
    }

    public void setOnMissingFileProperty(String onMissingFileProperty) {
        this.onMissingFileProperty = IgnoreWarnFailCreate.forString(onMissingFileProperty);
    }

    public void setOnMissingProperty(String onMissingProperty) {
        this.onMissingProperty = IgnoreWarnFail.forString(onMissingProperty);
    }

    public void setRegexp(String regexp) {
        Preconditions.checkState((boolean)regexp.startsWith("^"), (Object)"regular expression must start with '^'!");
        Preconditions.checkState((boolean)regexp.endsWith("$"), (Object)"regular expression must end with '$'!");
        this.regexp = Pattern.compile(regexp);
    }

    public void setTransformers(String transformers) {
        this.transformers = Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)transformers);
    }

    public abstract <U extends Field<?, ?>> U createField(FieldContext var1, ValueCache var2) throws IOException;

    public String getId() {
        return this.id;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public List<String> getTransformers() {
        return this.transformers;
    }

    public Optional<String> getInitialValue() {
        return Optional.ofNullable(this.initialValue);
    }

    public boolean isExport() {
        return this.export;
    }

    public String getPropertyNameInFile() {
        return Objects.requireNonNullElse(this.propertyNameInFile, this.id);
    }

    public Optional<File> getPropertyFile() {
        return Optional.ofNullable(this.propertyFile);
    }

    public IgnoreWarnFailCreate getOnMissingFile() {
        return this.onMissingFile;
    }

    public IgnoreWarnFailCreate getOnMissingFileProperty() {
        return this.onMissingFileProperty;
    }

    public IgnoreWarnFail getOnMissingProperty() {
        return this.onMissingProperty;
    }

    public Function<String, String> getRegexp() {
        return this.regexp == null ? Function.identity() : v -> {
            Matcher matcher = this.regexp.matcher((CharSequence)v);
            return matcher.matches() ? matcher.group(1) : "";
        };
    }

    public Function<T, String> getPreFormat() {
        return v -> v == null ? "" : String.valueOf(v);
    }

    public Function<String, String> getPostFormat() {
        return this.format == null ? String::valueOf : v -> String.format(this.format, v);
    }

    public void check() {
        Preconditions.checkState((this.id != null ? 1 : 0) != 0, (Object)"the id element must not be empty!");
        if (this.propertyNameInFile != null) {
            Preconditions.checkState((this.propertyFile != null ? 1 : 0) != 0, (Object)"can not define <propertyNameInFile> without defining <propertyFile>!");
        }
    }

    public String toString() {
        return new StringJoiner(", ", FieldDefinition.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("skip=" + this.skip).add("export=" + this.export).add("propertyNameInFile='" + this.propertyNameInFile + "'").add("propertyFile=" + this.propertyFile).add("onMissingFile=" + this.onMissingFile).add("onMissingFileProperty=" + this.onMissingFileProperty).add("onMissingProperty=" + this.onMissingProperty).add("initialValue='" + this.initialValue + "'").add("format='" + this.format + "'").add("transformers=" + this.transformers).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldDefinition that = (FieldDefinition)o;
        return this.skip == that.skip && this.export == that.export && Objects.equals(this.id, that.id) && Objects.equals(this.propertyNameInFile, that.propertyNameInFile) && Objects.equals(this.propertyFile, that.propertyFile) && this.onMissingFile == that.onMissingFile && this.onMissingFileProperty == that.onMissingFileProperty && this.onMissingProperty == that.onMissingProperty && Objects.equals(this.initialValue, that.initialValue) && Objects.equals(this.format, that.format) && Objects.equals(this.transformers, that.transformers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.skip, this.export, this.propertyNameInFile, this.propertyFile, this.onMissingFile, this.onMissingFileProperty, this.onMissingProperty, this.initialValue, this.format, this.transformers});
    }
}

