/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper.definitions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import org.basepom.mojo.propertyhelper.FieldContext;
import org.basepom.mojo.propertyhelper.ValueCache;
import org.basepom.mojo.propertyhelper.ValueProvider;
import org.basepom.mojo.propertyhelper.definitions.FieldDefinition;
import org.basepom.mojo.propertyhelper.fields.DateField;

public class DateDefinition
extends FieldDefinition<ZonedDateTime> {
    String timezone = null;
    Long value = null;

    public DateDefinition() {
    }

    @VisibleForTesting
    DateDefinition(String id) {
        super(id);
    }

    public ZoneId getTimezone() {
        return Optional.ofNullable(this.timezone).map(ZoneId::of).orElse(ZoneId.systemDefault());
    }

    public Optional<Long> getValue() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public DateField createField(FieldContext context, ValueCache valueCache) throws IOException {
        Preconditions.checkNotNull((Object)context, (Object)"context is null");
        Preconditions.checkNotNull((Object)valueCache, (Object)"valueCache is null");
        this.check();
        ValueProvider dateValue = valueCache.getValueProvider(this);
        return new DateField(this, dateValue, context);
    }

    @Override
    public Function<ZonedDateTime, String> getPreFormat() {
        DateTimeFormatter dateTimeFormatter = this.getFormatter().orElseGet(this::getFallbackFormatter);
        return v -> v == null ? "" : dateTimeFormatter.format((TemporalAccessor)v);
    }

    @Override
    public Function<String, String> getPostFormat() {
        return Function.identity();
    }

    public Function<String, ZonedDateTime> getParser() {
        return value -> this.getFormatter().map(f -> {
            try {
                return ZonedDateTime.parse(value, f);
            }
            catch (DateTimeParseException e) {
                return null;
            }
        }).orElseGet(() -> this.parseLong((String)value).map(this.getLongParser()).orElseGet(() -> ZonedDateTime.parse(value, this.getFallbackFormatter())));
    }

    private Optional<Long> parseLong(String value) {
        try {
            return Optional.of(Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public Function<Long, ZonedDateTime> getLongParser() {
        return longValue -> ZonedDateTime.ofInstant(Instant.ofEpochMilli(longValue), this.getTimezone());
    }

    public Optional<DateTimeFormatter> getFormatter() {
        return Optional.ofNullable(this.format).map(DateTimeFormatter::ofPattern).map(formatter -> formatter.withZone(this.getTimezone()));
    }

    public DateTimeFormatter getFallbackFormatter() {
        return DateTimeFormatter.ISO_DATE_TIME.withZone(this.getTimezone());
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", DateDefinition.class.getSimpleName() + "[", "]").add("timezone='" + this.timezone + "'").add("value=" + this.value).add(super.toString()).toString();
    }
}

