/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import com.google.common.flogger.FluentLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.StringJoiner;
import org.basepom.mojo.propertyhelper.IgnoreWarnFailCreate;
import org.basepom.mojo.propertyhelper.ValueProvider;
import org.basepom.mojo.propertyhelper.definitions.FieldDefinition;

public final class ValueCache {
    private static final FluentLogger LOG = FluentLogger.forEnclosingClass();
    private final Map<String, String> ephemeralValues = Maps.newHashMap();
    private final Map<File, ValueCacheEntry> valueFiles = Maps.newHashMap();

    @VisibleForTesting
    public ValueProvider findCurrentValueProvider(Map<String, String> values, FieldDefinition<?> definition) {
        Preconditions.checkNotNull(values, (Object)"values is null");
        String propertyNameInFile = definition.getPropertyNameInFile();
        boolean hasValue = values.containsKey(propertyNameInFile);
        boolean createProperty = IgnoreWarnFailCreate.checkIgnoreWarnFailCreateState(hasValue, definition.getOnMissingFileProperty(), () -> String.format("property '%s' has value '%s'", propertyNameInFile, values.get(propertyNameInFile)), () -> String.format("property '%s' has no value defined", propertyNameInFile));
        if (hasValue) {
            return new ValueProvider.MapBackedValueAdapter(values, propertyNameInFile);
        }
        if (createProperty) {
            Optional<String> initialValue = definition.getInitialValue();
            initialValue.ifPresent(value -> values.put(propertyNameInFile, (String)value));
            return new ValueProvider.MapBackedValueAdapter(values, propertyNameInFile);
        }
        return ValueProvider.NULL_PROVIDER;
    }

    public ValueProvider getValueProvider(FieldDefinition<?> definition) throws IOException {
        Optional<Map<String, String>> values = this.getValues(definition);
        if (values.isEmpty()) {
            String name = definition.getId();
            Optional<String> initialValue = definition.getInitialValue();
            initialValue.ifPresent(s -> this.ephemeralValues.put(name, (String)s));
            return new ValueProvider.MapBackedValueAdapter(this.ephemeralValues, name);
        }
        return this.findCurrentValueProvider(values.get(), definition);
    }

    @VisibleForTesting
    Optional<Map<String, String>> getValues(FieldDefinition<?> definition) throws IOException {
        Optional<File> definitionFile = definition.getPropertyFile();
        if (definitionFile.isEmpty()) {
            return Optional.empty();
        }
        File canonicalFile = definitionFile.get().getCanonicalFile();
        String canonicalPath = definitionFile.get().getCanonicalPath();
        boolean createFile = IgnoreWarnFailCreate.checkIgnoreWarnFailCreateState(canonicalFile.exists(), definition.getOnMissingFile(), () -> String.format("property file '%s' exists", canonicalPath), () -> String.format("property file '%s' does not exist!", canonicalPath));
        ValueCacheEntry cacheEntry = this.valueFiles.get(canonicalFile);
        if (cacheEntry != null) {
            if (createFile) {
                cacheEntry.doCreate();
            }
        } else {
            Properties props = new Properties();
            if (!canonicalFile.exists()) {
                cacheEntry = new ValueCacheEntry(props, false, createFile);
                this.valueFiles.put(canonicalFile, cacheEntry);
            } else if (canonicalFile.isFile() && canonicalFile.canRead()) {
                try (InputStream stream = Files.newInputStream(canonicalFile.toPath(), new OpenOption[0]);){
                    props.load(stream);
                    cacheEntry = new ValueCacheEntry(props, true, createFile);
                    this.valueFiles.put(canonicalFile, cacheEntry);
                }
            } else {
                throw new IllegalStateException(String.format("Can not load %s, not a file!", definitionFile.get().getCanonicalPath()));
            }
        }
        return Optional.of(cacheEntry.getValues());
    }

    public void persist() throws IOException {
        for (Map.Entry<File, ValueCacheEntry> entries : this.valueFiles.entrySet()) {
            File folder;
            ValueCacheEntry entry = entries.getValue();
            if (!entry.isDirty()) continue;
            File file = entries.getKey();
            if (!entry.isExists() && !entry.isCreate()) continue;
            Preconditions.checkNotNull((Object)file, (Object)"no file defined, can not persist!");
            File oldFile = new File(file.getCanonicalPath() + ".bak");
            if (entry.isExists()) {
                Preconditions.checkState((boolean)file.exists(), (String)"'%s' should exist!", (Object)file.getCanonicalPath());
                if (oldFile.exists()) {
                    Preconditions.checkState((boolean)oldFile.delete(), (String)"Could not delete '%s'", (Object)file.getCanonicalPath());
                }
            }
            if (!(folder = file.getParentFile()).exists()) {
                Preconditions.checkState((boolean)folder.mkdirs(), (String)"Could not create folder '%s'", (Object)folder.getCanonicalPath());
            }
            File newFile = new File(file.getCanonicalPath() + ".new");
            try (OutputStream stream = Files.newOutputStream(newFile.toPath(), new OpenOption[0]);){
                entry.store(stream, "created by property-helper-maven-plugin");
            }
            if (file.exists() && !file.renameTo(oldFile)) {
                ((FluentLogger.Api)LOG.atWarning()).log("Could not rename '%s' to '%s'!", (Object)file, (Object)oldFile);
            }
            if (file.exists() || newFile.renameTo(file)) continue;
            ((FluentLogger.Api)LOG.atWarning()).log("Could not rename '%s' to '%s'!", (Object)newFile, (Object)file);
        }
    }

    public static class ValueCacheEntry {
        private final Map<String, String> values = Maps.newHashMap();
        private final boolean exists;
        private boolean create;
        private boolean dirty = false;

        ValueCacheEntry(Properties props, boolean exists, boolean create) {
            Preconditions.checkNotNull((Object)props, (Object)"props is null");
            this.values.putAll((Map<String, String>)Maps.fromProperties((Properties)props));
            this.exists = exists;
            this.create = create;
        }

        public void store(OutputStream out, String comment) throws IOException {
            Properties p = new Properties();
            for (Map.Entry<String, String> entry : this.values.entrySet()) {
                p.setProperty(entry.getKey(), entry.getValue());
            }
            p.store(out, comment);
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void dirty() {
            this.dirty = true;
        }

        public Map<String, String> getValues() {
            return new ForwardingMap<String, String>(){

                protected Map<String, String> delegate() {
                    return values;
                }

                public String remove(Object object) {
                    this.dirty();
                    return (String)super.remove(object);
                }

                public void clear() {
                    this.dirty();
                    super.clear();
                }

                public String put(String key, String value) {
                    String oldValue = (String)super.put((Object)key, (Object)value);
                    if (!Objects.equals(value, oldValue)) {
                        this.dirty();
                    }
                    return oldValue;
                }

                public void putAll(Map<? extends String, ? extends String> map) {
                    this.dirty();
                    super.putAll(map);
                }
            };
        }

        public boolean isExists() {
            return this.exists;
        }

        public boolean isCreate() {
            return this.create;
        }

        public void doCreate() {
            this.create = true;
            this.dirty();
        }

        public String toString() {
            return new StringJoiner(", ", ValueCacheEntry.class.getSimpleName() + "[", "]").add("values=" + this.values).add("exists=" + this.exists).add("create=" + this.create).add("dirty=" + this.dirty).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValueCacheEntry that = (ValueCacheEntry)o;
            return this.exists == that.exists && this.create == that.create && this.dirty == that.dirty && Objects.equals(this.values, that.values);
        }

        public int hashCode() {
            return Objects.hash(this.values, this.exists, this.create, this.dirty);
        }
    }
}

