/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper;

import com.google.common.flogger.FluentLogger;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.basepom.mojo.propertyhelper.AbstractPropertyHelperMojo;
import org.basepom.mojo.propertyhelper.fields.NumberField;

@Mojo(name="inc", threadSafe=true)
public final class IncMojo
extends AbstractPropertyHelperMojo {
    private static final FluentLogger LOG = FluentLogger.forEnclosingClass();
    @Parameter(defaultValue="true")
    boolean persist = true;

    @Override
    protected void doExecute() throws IOException, MojoExecutionException {
        ((FluentLogger.Api)LOG.atFine()).log("Running IncrementNumbers");
        this.createFieldDefinitions();
        this.createFields();
        this.createGroups();
        List<NumberField> numberFields = this.getNumbers();
        if (numberFields != null) {
            for (NumberField nf : numberFields) {
                nf.increment();
            }
        }
        if (this.persist) {
            this.valueCache.persist();
        }
    }
}

