/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper;

import com.google.common.base.Preconditions;
import com.google.common.flogger.FluentLogger;
import java.util.Locale;
import java.util.function.Supplier;

public enum IgnoreWarnFailCreate {
    IGNORE,
    WARN,
    FAIL,
    CREATE;

    private static final FluentLogger LOG;

    public static IgnoreWarnFailCreate forString(String value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"the value can not be null");
        return Enum.valueOf(IgnoreWarnFailCreate.class, value.toUpperCase(Locale.getDefault()));
    }

    public static boolean checkIgnoreWarnFailCreateState(boolean check, IgnoreWarnFailCreate iwfc, Supplier<String> checkMessage, Supplier<String> errorMessage) {
        if (check) {
            ((FluentLogger.Api)LOG.atFine()).log(checkMessage.get());
            return false;
        }
        switch (iwfc) {
            case IGNORE: {
                return false;
            }
            case WARN: {
                ((FluentLogger.Api)LOG.atWarning()).log(errorMessage.get());
                return false;
            }
            case FAIL: {
                throw new IllegalStateException(errorMessage.get());
            }
            case CREATE: {
                ((FluentLogger.Api)LOG.atFine()).log(errorMessage.get());
                return true;
            }
        }
        throw new IllegalStateException("Unknown state: " + iwfc);
    }

    static {
        LOG = FluentLogger.forEnclosingClass();
    }
}

