/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper.beans;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.basepom.mojo.propertyhelper.beans.AbstractDefinition;
import org.basepom.mojo.propertyhelper.beans.IgnoreWarnFail;

public class StringDefinition
extends AbstractDefinition<StringDefinition> {
    List<String> values = ImmutableList.of();
    boolean blankIsValid = true;
    IgnoreWarnFail onMissingValue = IgnoreWarnFail.FAIL;

    public List<String> getValues() {
        return this.values;
    }

    @VisibleForTesting
    public StringDefinition setValues(List<String> values) {
        Preconditions.checkNotNull(values, (Object)"values is null");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String value : values) {
            builder.add((Object)Objects.requireNonNullElse(value, ""));
        }
        this.values = builder.build();
        return this;
    }

    public boolean isBlankIsValid() {
        return this.blankIsValid;
    }

    @VisibleForTesting
    public StringDefinition setBlankIsValid(boolean blankIsValid) {
        this.blankIsValid = blankIsValid;
        return this;
    }

    public IgnoreWarnFail getOnMissingValue() {
        return this.onMissingValue;
    }

    @VisibleForTesting
    public StringDefinition setOnMissingValue(String onMissingValue) {
        Preconditions.checkNotNull((Object)onMissingValue, (Object)"onMissingValue is null");
        this.onMissingValue = IgnoreWarnFail.forString(onMissingValue);
        return this;
    }
}

