/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper.beans;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.StringJoiner;
import org.basepom.mojo.propertyhelper.beans.AbstractDefinition;

public class MacroDefinition
extends AbstractDefinition<MacroDefinition> {
    String macroType = null;
    String macroClass = null;
    Properties properties = new Properties();

    public Optional<String> getMacroType() {
        return Optional.ofNullable(this.macroType);
    }

    @VisibleForTesting
    public MacroDefinition setMacroType(String macroType) {
        this.macroType = (String)Preconditions.checkNotNull((Object)macroType, (Object)"macroType is null");
        return this;
    }

    public Optional<String> getMacroClass() {
        return Optional.ofNullable(this.macroClass);
    }

    @VisibleForTesting
    public MacroDefinition setMacroClass(String macroClass) {
        this.macroClass = (String)Preconditions.checkNotNull((Object)macroClass, (Object)"macroClass is null");
        return this;
    }

    public Map<String, String> getProperties() {
        return ImmutableMap.copyOf((Map)Maps.fromProperties((Properties)this.properties));
    }

    @VisibleForTesting
    public MacroDefinition setProperties(Properties properties) {
        this.properties = new Properties((Properties)Preconditions.checkNotNull((Object)properties, (Object)"properties is null"));
        return this;
    }

    @Override
    public void check() {
        super.check();
        Preconditions.checkState((this.macroClass != null || this.macroType != null ? 1 : 0) != 0, (Object)"neither macro class nor macro type is defined!");
    }

    public String toString() {
        return new StringJoiner(", ", MacroDefinition.class.getSimpleName() + "[", "]").add("macroType='" + this.macroType + "'").add("macroClass='" + this.macroClass + "'").add("properties=" + this.properties).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MacroDefinition that = (MacroDefinition)o;
        return Objects.equals(this.macroType, that.macroType) && Objects.equals(this.macroClass, that.macroClass) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.macroType, this.macroClass, this.properties);
    }
}

