/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public interface ValueProvider {
    public static final ValueProvider NULL_PROVIDER = new NullProvider();

    public Optional<String> getValue();

    public void setValue(String var1);

    public static class NullProvider
    implements ValueProvider {
        private NullProvider() {
        }

        @Override
        public Optional<String> getValue() {
            return Optional.empty();
        }

        @Override
        public void setValue(String value) {
        }
    }

    public static class PropertyProvider
    implements ValueProvider {
        private final Properties props;
        private final String propertyName;

        PropertyProvider(Properties props, String propertyName) {
            this.props = props;
            this.propertyName = (String)Preconditions.checkNotNull((Object)propertyName, (Object)"propertyName is null");
        }

        @Override
        public Optional<String> getValue() {
            return Optional.ofNullable(this.props.getProperty(this.propertyName));
        }

        @Override
        public void setValue(String value) {
            Preconditions.checkNotNull((Object)value, (Object)"value is null");
            this.props.setProperty(this.propertyName, value);
        }
    }

    public static class MapValueProvider
    implements ValueProvider {
        private final Map<String, String> values;
        private final String valueName;

        MapValueProvider(Map<String, String> values, String valueName) {
            this.valueName = (String)Preconditions.checkNotNull((Object)valueName, (Object)"valueName is null");
            this.values = values;
        }

        @Override
        public Optional<String> getValue() {
            return Optional.ofNullable(this.values.get(this.valueName));
        }

        @Override
        public void setValue(String value) {
            Preconditions.checkNotNull((Object)value, (Object)"value is null");
            this.values.put(this.valueName, value);
        }
    }

    public static class StaticValueProvider
    implements ValueProvider {
        private String value;

        StaticValueProvider() {
        }

        @Override
        public Optional<String> getValue() {
            return Optional.ofNullable(this.value);
        }

        @Override
        public void setValue(String value) {
            this.value = value;
        }
    }
}

