/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.basepom.mojo.propertyhelper.PropertyElement;
import org.basepom.mojo.propertyhelper.ValueCache;
import org.basepom.mojo.propertyhelper.ValueProvider;
import org.basepom.mojo.propertyhelper.beans.IgnoreWarnFail;
import org.basepom.mojo.propertyhelper.beans.StringDefinition;

public class StringField
implements PropertyElement {
    private final StringDefinition stringDefinition;
    private final ValueProvider valueProvider;

    public StringField(StringDefinition stringDefinition, ValueProvider valueProvider) {
        this.stringDefinition = stringDefinition;
        this.valueProvider = valueProvider;
    }

    public static List<StringField> createStrings(ValueCache valueCache, StringDefinition ... stringDefinitions) throws IOException {
        Preconditions.checkNotNull((Object)valueCache, (Object)"valueCache is null");
        ImmutableList.Builder result = ImmutableList.builder();
        for (StringDefinition stringDefinition : stringDefinitions) {
            stringDefinition.check();
            ValueProvider stringValue = valueCache.getValueProvider(stringDefinition);
            StringField stringField = new StringField(stringDefinition, stringValue);
            result.add((Object)stringField);
        }
        return result.build();
    }

    @Override
    public String getPropertyName() {
        return this.stringDefinition.getId();
    }

    @Override
    public Optional<String> getPropertyValue() {
        ArrayList values = Lists.newArrayList();
        Optional<String> propValue = this.valueProvider.getValue();
        List<String> definedValues = this.stringDefinition.getValues();
        propValue.ifPresent(values::add);
        values.addAll(definedValues);
        for (String value : values) {
            if (!this.stringDefinition.isBlankIsValid() && (value == null || value.trim().isEmpty())) continue;
            return this.stringDefinition.formatResult(value);
        }
        IgnoreWarnFail.checkState(this.stringDefinition.getOnMissingValue(), false, "value");
        return Optional.empty();
    }

    @Override
    public boolean isExport() {
        return this.stringDefinition.isExport();
    }

    public String toString() {
        return this.getPropertyValue().orElse("");
    }
}

