/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basepom.mojo.propertyhelper.PropertyElement;
import org.basepom.mojo.propertyhelper.ValueCache;
import org.basepom.mojo.propertyhelper.ValueProvider;
import org.basepom.mojo.propertyhelper.beans.NumberDefinition;

public class NumberField
implements PropertyElement {
    private static final Pattern MATCH_GROUPS = Pattern.compile("\\d+|\\D+");
    private final NumberDefinition numberDefinition;
    private final ValueProvider valueProvider;
    private final List<String> elements = Lists.newArrayList();
    private final List<Integer> numberElements = Lists.newArrayList();

    public NumberField(NumberDefinition numberDefinition, ValueProvider valueProvider) {
        this.numberDefinition = numberDefinition;
        this.valueProvider = valueProvider;
    }

    public static List<NumberField> createNumbers(ValueCache valueCache, NumberDefinition ... numberDefinitions) throws IOException {
        Preconditions.checkNotNull((Object)valueCache, (Object)"valueCache is null");
        ArrayList result = Lists.newArrayList();
        for (NumberDefinition numberDefinition : numberDefinitions) {
            numberDefinition.check();
            ValueProvider numberValue = valueCache.getValueProvider(numberDefinition);
            NumberField numberField = new NumberField(numberDefinition, numberValue);
            result.add(numberField);
        }
        return result;
    }

    @Override
    public String getPropertyName() {
        return this.numberDefinition.getId();
    }

    @Override
    public Optional<String> getPropertyValue() {
        this.parse();
        String value = Joiner.on((String)"").join(this.elements);
        return this.numberDefinition.formatResult(value);
    }

    @Override
    public boolean isExport() {
        return this.numberDefinition.isExport();
    }

    private void parse() {
        Optional<String> value = this.valueProvider.getValue();
        if (value.isPresent()) {
            Matcher m = MATCH_GROUPS.matcher(value.get());
            this.elements.clear();
            this.numberElements.clear();
            while (m.find()) {
                String matchValue = m.group();
                this.elements.add(matchValue);
                if (!this.isNumber(matchValue)) continue;
                this.numberElements.add(this.elements.size() - 1);
            }
            Preconditions.checkState((this.numberElements.size() > this.numberDefinition.getFieldNumber() ? 1 : 0) != 0, (String)"Only %d fields in %s, field %d requested.", (Object)this.numberElements.size(), value, (Object)this.numberDefinition.getFieldNumber());
        }
    }

    private boolean isNumber(CharSequence c) {
        for (int i = 0; i < c.length(); ++i) {
            if (Character.isDigit(c.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void increment() {
        Long value = this.getNumberValue();
        if (value != null) {
            this.setNumberValue(value + (long)this.numberDefinition.getIncrement());
        }
    }

    public Long getNumberValue() {
        this.parse();
        return this.numberElements.isEmpty() ? null : Long.valueOf(this.elements.get(this.numberElements.get(this.numberDefinition.getFieldNumber())));
    }

    public void setNumberValue(Long value) {
        this.parse();
        if (!this.numberElements.isEmpty()) {
            this.elements.set(this.numberElements.get(this.numberDefinition.getFieldNumber()), value.toString());
            this.valueProvider.setValue(Joiner.on((String)"").join(this.elements));
        }
    }

    public String toString() {
        return this.getPropertyValue().orElse("");
    }
}

