/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.basepom.mojo.propertyhelper.AbstractPropertyHelperMojo;
import org.basepom.mojo.propertyhelper.PropertyElement;
import org.basepom.mojo.propertyhelper.ValueCache;
import org.basepom.mojo.propertyhelper.ValueProvider;
import org.basepom.mojo.propertyhelper.beans.MacroDefinition;
import org.basepom.mojo.propertyhelper.macros.MacroType;

public class MacroField
implements PropertyElement {
    private final MacroDefinition macroDefinition;
    private final ValueProvider valueProvider;
    private final AbstractPropertyHelperMojo mojo;

    public MacroField(MacroDefinition macroDefinition, ValueProvider valueProvider, AbstractPropertyHelperMojo mojo) {
        this.macroDefinition = macroDefinition;
        this.valueProvider = valueProvider;
        this.mojo = mojo;
    }

    public static List<MacroField> createMacros(ValueCache valueCache, MacroDefinition[] macroDefinitions, AbstractPropertyHelperMojo mojo) throws IOException {
        Preconditions.checkNotNull((Object)valueCache, (Object)"valueCache is null");
        Preconditions.checkNotNull((Object)macroDefinitions, (Object)"macroDefinitions is null");
        Preconditions.checkNotNull((Object)((Object)mojo), (Object)"mojo is null");
        ImmutableList.Builder result = ImmutableList.builder();
        for (MacroDefinition macroDefinition : macroDefinitions) {
            macroDefinition.check();
            ValueProvider macroValue = valueCache.getValueProvider(macroDefinition);
            MacroField macroField = new MacroField(macroDefinition, macroValue, mojo);
            result.add((Object)macroField);
        }
        return result.build();
    }

    @Override
    public String getPropertyName() {
        return this.macroDefinition.getId();
    }

    @Override
    public Optional<String> getPropertyValue() throws MojoExecutionException {
        Optional<String> type = this.macroDefinition.getMacroType();
        try {
            MacroType macroType;
            if (type.isPresent()) {
                macroType = this.mojo.getMacros().get(type.get());
                Preconditions.checkState((macroType != null ? 1 : 0) != 0, (String)"Could not locate macro '%s'", (Object)type.get());
            } else {
                Optional<String> macroClassName = this.macroDefinition.getMacroClass();
                Preconditions.checkState((boolean)macroClassName.isPresent(), (String)"No definition for macro '%s' found!", (Object)this.macroDefinition.getId());
                Class<?> macroClass = Class.forName(macroClassName.get());
                macroType = (MacroType)macroClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            Optional<String> result = macroType.getValue(this.macroDefinition, this.valueProvider, this.mojo);
            if (result.isPresent()) {
                return this.macroDefinition.formatResult(result.get());
            }
            return result;
        }
        catch (ReflectiveOperationException e) {
            throw new MojoExecutionException(String.format("Could not instantiate '%s'", this.macroDefinition), (Exception)e);
        }
    }

    @Override
    public boolean isExport() {
        return this.macroDefinition.isExport();
    }

    public String toString() {
        try {
            return this.getPropertyValue().orElse("");
        }
        catch (Exception e) {
            return "<unset>";
        }
    }
}

