/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.basepom.mojo.propertyhelper.PropertyElement;
import org.basepom.mojo.propertyhelper.TransformerRegistry;
import org.basepom.mojo.propertyhelper.ValueCache;
import org.basepom.mojo.propertyhelper.ValueProvider;
import org.basepom.mojo.propertyhelper.beans.DateDefinition;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateField
implements PropertyElement {
    private final DateDefinition dateDefinition;
    private final ValueProvider valueProvider;

    public DateField(DateDefinition dateDefinition, ValueProvider valueProvider) {
        this.dateDefinition = dateDefinition;
        this.valueProvider = valueProvider;
    }

    public static List<DateField> createDates(ValueCache valueCache, DateDefinition ... dateDefinitions) throws IOException {
        Preconditions.checkNotNull((Object)valueCache, (Object)"valueCache is null");
        ImmutableList.Builder result = ImmutableList.builder();
        for (DateDefinition dateDefinition : dateDefinitions) {
            dateDefinition.check();
            ValueProvider dateValue = valueCache.getValueProvider(dateDefinition);
            DateField dateField = new DateField(dateDefinition, dateValue);
            result.add((Object)dateField);
        }
        return result.build();
    }

    @Override
    public String getPropertyName() {
        return this.dateDefinition.getId();
    }

    @Override
    public Optional<String> getPropertyValue() {
        String result;
        DateTimeZone timeZone = this.dateDefinition.getTimezone().isPresent() ? DateTimeZone.forID((String)this.dateDefinition.getTimezone().get()) : DateTimeZone.getDefault();
        Optional<String> format = this.dateDefinition.getFormat();
        DateTimeFormatter formatter = format.map(DateTimeFormat::forPattern).orElse(null);
        DateTime date = this.valueProvider.getValue().map(value -> this.getDateTime((String)value, formatter, timeZone)).orElse(null);
        if (date == null && this.dateDefinition.getValue().isPresent()) {
            date = new DateTime((Object)this.dateDefinition.getValue().get(), timeZone);
        }
        if (date == null) {
            date = new DateTime(timeZone);
        }
        if (formatter != null) {
            result = formatter.print((ReadableInstant)date);
            this.valueProvider.setValue(result);
        } else {
            result = date.toString();
            this.valueProvider.setValue(Long.toString(date.getMillis()));
        }
        if (this.dateDefinition.getTransformers().isPresent()) {
            result = TransformerRegistry.applyTransformers(this.dateDefinition.getTransformers().get(), result);
        }
        return Optional.ofNullable(result);
    }

    private DateTime getDateTime(String value, DateTimeFormatter formatter, DateTimeZone timeZone) {
        if (value == null) {
            return null;
        }
        if (formatter != null) {
            return formatter.parseDateTime(value).withZone(timeZone);
        }
        try {
            return new DateTime(Long.parseLong(value), timeZone);
        }
        catch (NumberFormatException nfe) {
            return new DateTime((Object)value, timeZone);
        }
    }

    @Override
    public boolean isExport() {
        return this.dateDefinition.isExport();
    }

    public String toString() {
        return this.getPropertyValue().orElse("");
    }
}

