/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.mojo;

import com.google.common.base.Preconditions;
import org.apache.maven.artifact.Artifact;
import org.basepom.inline.mojo.ArtifactIdentifier;
import org.eclipse.aether.graph.Dependency;

public final class InlineDependency {
    private ArtifactIdentifier artifactIdentifier = null;
    private boolean transitive = true;
    private boolean optionals = false;

    public void setArtifact(String artifact) {
        this.artifactIdentifier = new ArtifactIdentifier(artifact);
    }

    public ArtifactIdentifier getArtifactIdentifier() {
        Preconditions.checkState((this.artifactIdentifier != null ? 1 : 0) != 0, (Object)"no artifact has been set!");
        return this.artifactIdentifier;
    }

    public boolean isInlineTransitive() {
        return this.transitive;
    }

    public InlineDependency setInlineTransitive(boolean transitive) {
        this.transitive = transitive;
        return this;
    }

    public boolean isInlineOptionals() {
        return this.optionals;
    }

    public InlineDependency setInlineOptionals(boolean optionals) {
        this.optionals = optionals;
        return this;
    }

    public boolean matchDependency(Dependency dependency) {
        return this.getArtifactIdentifier().matchDependency(dependency);
    }

    public boolean matchArtifact(Artifact artifact) {
        return this.getArtifactIdentifier().matchArtifact(artifact);
    }

    public String toString() {
        String flags = this.transitive ? "inline transitive" : "";
        return String.format("%s [%s]", this.artifactIdentifier, flags);
    }
}

