/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.mojo;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;

public final class ArtifactIdentifier {
    private final String artifactId;
    private final String groupId;

    public ArtifactIdentifier(String artifact) {
        Preconditions.checkNotNull((Object)artifact, (Object)"artifact is null");
        List elements = Splitter.on((char)':').trimResults().splitToList((CharSequence)artifact);
        Preconditions.checkState((elements.size() == 2 ? 1 : 0) != 0, (String)"artifact format is <groupId>:<artifactId> (got %s)", (Object)artifact);
        this.groupId = (String)elements.get(0);
        this.artifactId = (String)elements.get(1);
    }

    public ArtifactIdentifier(Dependency dependency) {
        Preconditions.checkNotNull((Object)dependency, (Object)"dependency is null");
        this.groupId = dependency.getArtifact().getGroupId();
        this.artifactId = dependency.getArtifact().getArtifactId();
    }

    public ArtifactIdentifier(Artifact artifact) {
        this.groupId = artifact.getGroupId();
        this.artifactId = artifact.getArtifactId();
    }

    public ArtifactIdentifier(DependencyNode dependencyNode) {
        Preconditions.checkNotNull((Object)dependencyNode, (Object)"dependencyNode is null");
        this.groupId = dependencyNode.getArtifact().getGroupId();
        this.artifactId = dependencyNode.getArtifact().getArtifactId();
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public boolean matchDependency(Dependency dependency) {
        return Optional.ofNullable(dependency).map(Dependency::getArtifact).map(a -> this.match(a.getGroupId(), a.getArtifactId())).orElse(false);
    }

    public boolean matchArtifact(Artifact artifact) {
        return Optional.of(artifact).map(a -> this.match(a.getGroupId(), a.getArtifactId())).orElse(false);
    }

    private boolean match(String groupId, String artifactId) {
        return !(!this.getArtifactId().equals("*") && !this.getArtifactId().equals(artifactId) || !this.getGroupId().equals("*") && !this.getGroupId().equals(groupId));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactIdentifier that = (ArtifactIdentifier)o;
        return this.artifactId.equals(that.artifactId) && this.groupId.equals(that.groupId);
    }

    public int hashCode() {
        return Objects.hash(this.artifactId, this.groupId);
    }

    public String toString() {
        return String.format("%s:%s", this.groupId, this.artifactId);
    }
}

