/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.duplicatefinder.classpath;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.basepom.mojo.duplicatefinder.PluginLog;

class MatchPatternPredicate
implements Predicate<String> {
    private static final PluginLog LOG = new PluginLog(MatchPatternPredicate.class);
    private final ImmutableList<Pattern> patterns;

    MatchPatternPredicate(Collection<String> patternStrings) {
        Preconditions.checkNotNull(patternStrings, (Object)"patternStrings is null");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String patternString : patternStrings) {
            builder.add((Object)Pattern.compile(patternString, 66));
        }
        this.patterns = builder.build();
    }

    public ImmutableList<Pattern> getPatterns() {
        return this.patterns;
    }

    public boolean apply(@Nonnull String input) {
        String value = input;
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(value).matches()) continue;
            LOG.debug("Ignoring '%s' (matches %s)", input, pattern.pattern());
            return true;
        }
        return false;
    }
}

