/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.dependencyscope;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Exclusion;

public final class TraversalContext {
    private static final String WILDCARD = "*";
    private final org.apache.maven.artifact.Artifact artifact;
    private final ImmutableList<org.apache.maven.artifact.Artifact> path;
    private final ImmutableSet<String> testScopedArtifacts;
    private final ImmutableMap<String, String> dependencyVersions;
    private final ImmutableSet<Exclusion> exclusions;
    private final ImmutableMap<String, ImmutableSet<Exclusion>> dependencyManagementExclusions;

    private TraversalContext(org.apache.maven.artifact.Artifact artifact, ImmutableList<org.apache.maven.artifact.Artifact> path, ImmutableSet<String> testScopedArtifacts, ImmutableMap<String, String> dependencyVersions, ImmutableSet<Exclusion> exclusions, ImmutableMap<String, ImmutableSet<Exclusion>> dependencyManagementExclusions) {
        this.artifact = artifact;
        this.path = path;
        this.testScopedArtifacts = testScopedArtifacts;
        this.dependencyVersions = dependencyVersions;
        this.exclusions = exclusions;
        this.dependencyManagementExclusions = dependencyManagementExclusions;
    }

    public static TraversalContext newContextFor(MavenProject project, DependencyNode node) {
        ImmutableSet testScopedArtifacts = (ImmutableSet)node.getChildren().stream().filter(dependency -> "test".equals(dependency.getArtifact().getScope())).map(dependency -> dependency.getArtifact().getDependencyConflictId()).collect(ImmutableSet.toImmutableSet());
        ImmutableMap dependencyVersions = (ImmutableMap)project.getArtifacts().stream().collect(ImmutableMap.toImmutableMap(org.apache.maven.artifact.Artifact::getDependencyConflictId, org.apache.maven.artifact.Artifact::getBaseVersion));
        ImmutableMap dependencyManagementExclusions = project.getDependencyManagement() == null ? ImmutableMap.of() : (ImmutableMap)project.getDependencyManagement().getDependencies().stream().collect(ImmutableMap.toImmutableMap(Dependency::getManagementKey, TraversalContext::exclusions));
        return new TraversalContext(node.getArtifact(), (ImmutableList<org.apache.maven.artifact.Artifact>)ImmutableList.of((Object)node.getArtifact()), (ImmutableSet<String>)testScopedArtifacts, (ImmutableMap<String, String>)dependencyVersions, (ImmutableSet<Exclusion>)ImmutableSet.of(), (ImmutableMap<String, ImmutableSet<Exclusion>>)dependencyManagementExclusions);
    }

    public TraversalContext extendManagedDependencyExclusions(List<org.eclipse.aether.graph.Dependency> dependencies) {
        if (dependencies.isEmpty()) {
            return this;
        }
        ImmutableMap newExclusions = (ImmutableMap)dependencies.stream().filter(dependency -> !dependency.getExclusions().isEmpty()).collect(ImmutableMap.toImmutableMap(TraversalContext::computeDependencyKey, dependency -> ImmutableSet.copyOf((Collection)dependency.getExclusions())));
        ImmutableMap<String, ImmutableSet<Exclusion>> mergedExclusions = TraversalContext.merge(this.dependencyManagementExclusions, (ImmutableMap<String, ImmutableSet<Exclusion>>)newExclusions);
        return new TraversalContext(this.artifact, this.path, this.testScopedArtifacts, this.dependencyVersions, this.exclusions, mergedExclusions);
    }

    public TraversalContext stepInto(MavenProject project, DependencyNode node) {
        String artifactKey = node.getArtifact().getDependencyConflictId();
        ImmutableList path = ImmutableList.builderWithExpectedSize((int)(this.path.size() + 1)).addAll(this.path).add((Object)node.getArtifact()).build();
        Sets.SetView exclusions = this.exclusions;
        if (this.dependencyManagementExclusions.containsKey((Object)artifactKey)) {
            Set toAdd = (Set)this.dependencyManagementExclusions.get((Object)artifactKey);
            assert (toAdd != null);
            exclusions = Sets.union(exclusions, (Set)toAdd);
        }
        for (Dependency dependency : project.getDependencies()) {
            if (!artifactKey.equals(dependency.getManagementKey()) || dependency.getExclusions().isEmpty()) continue;
            exclusions = Sets.union((Set)exclusions, TraversalContext.exclusions(dependency));
        }
        return new TraversalContext(node.getArtifact(), (ImmutableList<org.apache.maven.artifact.Artifact>)path, this.testScopedArtifacts, this.dependencyVersions, (ImmutableSet<Exclusion>)ImmutableSet.copyOf((Collection)exclusions), this.dependencyManagementExclusions);
    }

    public Optional<TraversalContext> stepInto(org.eclipse.aether.graph.Dependency dependency) {
        org.apache.maven.artifact.Artifact artifact = TraversalContext.fromAether(dependency);
        String projectVersion = (String)this.dependencyVersions.get((Object)artifact.getDependencyConflictId());
        if (projectVersion == null) {
            return Optional.empty();
        }
        artifact = TraversalContext.withVersion(artifact, projectVersion);
        ImmutableList path = ImmutableList.builderWithExpectedSize((int)(this.path.size() + 1)).addAll(this.path).add((Object)artifact).build();
        ImmutableSet exclusions = this.exclusions;
        if (this.dependencyManagementExclusions.containsKey((Object)artifact.getDependencyConflictId())) {
            Set toAdd = (Set)this.dependencyManagementExclusions.get((Object)artifact.getDependencyConflictId());
            assert (toAdd != null);
            exclusions = Sets.union(exclusions, (Set)toAdd).immutableCopy();
        }
        return Optional.of(new TraversalContext(artifact, (ImmutableList<org.apache.maven.artifact.Artifact>)path, this.testScopedArtifacts, this.dependencyVersions, exclusions, this.dependencyManagementExclusions));
    }

    public boolean isExcluded(org.eclipse.aether.graph.Dependency dependency) {
        for (Exclusion exclusion : this.exclusions) {
            if (!TraversalContext.matches(dependency, exclusion)) continue;
            return true;
        }
        return false;
    }

    public boolean isOverriddenToTestScope(org.eclipse.aether.graph.Dependency dependency) {
        return this.testScopedArtifacts.contains((Object)TraversalContext.computeDependencyKey(dependency));
    }

    public org.apache.maven.artifact.Artifact currentArtifact() {
        return this.artifact;
    }

    public List<org.apache.maven.artifact.Artifact> path() {
        return this.path;
    }

    private static boolean matches(org.eclipse.aether.graph.Dependency dependency, Exclusion exclusion) {
        Artifact artifact = dependency.getArtifact();
        return !(!artifact.getGroupId().equals(exclusion.getGroupId()) || !artifact.getArtifactId().equals(exclusion.getArtifactId()) || !WILDCARD.equals(exclusion.getClassifier()) && !artifact.getClassifier().equals(exclusion.getClassifier()) || !WILDCARD.equals(exclusion.getExtension()) && !artifact.getExtension().equals(exclusion.getExtension()));
    }

    private static ImmutableMap<String, ImmutableSet<Exclusion>> merge(ImmutableMap<String, ImmutableSet<Exclusion>> a, ImmutableMap<String, ImmutableSet<Exclusion>> b) {
        MapDifference diff = Maps.difference(a, b);
        ImmutableMap.Builder merged = ImmutableMap.builder();
        merged.putAll(diff.entriesOnlyOnLeft());
        merged.putAll(diff.entriesOnlyOnRight());
        merged.putAll(diff.entriesInCommon());
        diff.entriesDiffering().forEach((key, valueDifference) -> {
            ImmutableSet mergedValue = Sets.union((Set)((Set)valueDifference.leftValue()), (Set)((Set)valueDifference.rightValue())).immutableCopy();
            merged.put(key, (Object)mergedValue);
        });
        return merged.build();
    }

    private static ImmutableSet<Exclusion> exclusions(Dependency dependency) {
        return (ImmutableSet)dependency.getExclusions().stream().map(exclusion -> new Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), WILDCARD, WILDCARD)).collect(ImmutableSet.toImmutableSet());
    }

    private static org.apache.maven.artifact.Artifact fromAether(org.eclipse.aether.graph.Dependency dependency) {
        Artifact artifact = dependency.getArtifact();
        return new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), VersionRange.createFromVersion((String)artifact.getVersion()), dependency.getScope(), artifact.getExtension(), artifact.getClassifier().isEmpty() ? null : artifact.getClassifier(), (ArtifactHandler)new DefaultArtifactHandler(artifact.getExtension()), dependency.isOptional());
    }

    private static org.apache.maven.artifact.Artifact withVersion(org.apache.maven.artifact.Artifact artifact, String version) {
        return new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), VersionRange.createFromVersion((String)version), artifact.getScope(), artifact.getType(), artifact.getClassifier(), artifact.getArtifactHandler(), artifact.isOptional());
    }

    private static String computeDependencyKey(org.eclipse.aether.graph.Dependency dependency) {
        Artifact artifact = dependency.getArtifact();
        StringBuilder builder = new StringBuilder().append(artifact.getGroupId()).append(':').append(artifact.getArtifactId()).append(':').append(artifact.getExtension());
        if (!artifact.getClassifier().isEmpty()) {
            builder.append(':').append(artifact.getClassifier());
        }
        return builder.toString();
    }
}

