/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Objects;
import lombok.Generated;
import org.bardframework.time.ChronologyJalali;
import org.bardframework.time.LocalDateJalali;
import org.bardframework.time.MonthJalali;

public final class YearMonthJalali
implements Temporal,
TemporalAdjuster,
Comparable<YearMonthJalali>,
Serializable {
    private static final long serialVersionUID = 4183400860270640070L;
    private static final DateTimeFormatter PARSER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).toFormatter();
    private final int year;
    private final int month;

    private YearMonthJalali(int year, int month) {
        this.year = year;
        this.month = month;
    }

    public static YearMonthJalali now() {
        return YearMonthJalali.now(Clock.systemDefaultZone());
    }

    public static YearMonthJalali now(ZoneId zone) {
        return YearMonthJalali.now(Clock.system(zone));
    }

    public static YearMonthJalali now(Clock clock) {
        LocalDateJalali now = LocalDateJalali.now(clock);
        return YearMonthJalali.of(now.getYear(), now.getMonth());
    }

    public static YearMonthJalali of(int year, MonthJalali month) {
        Objects.requireNonNull(month, "month");
        return YearMonthJalali.of(year, month.getValue());
    }

    public static YearMonthJalali of(int year, int month) {
        ChronoField.YEAR.checkValidValue(year);
        ChronoField.MONTH_OF_YEAR.checkValidValue(month);
        return new YearMonthJalali(year, month);
    }

    public static YearMonthJalali from(TemporalAccessor temporal) {
        if (temporal instanceof YearMonthJalali) {
            return (YearMonthJalali)temporal;
        }
        Objects.requireNonNull(temporal, "temporal");
        try {
            if (!ChronologyJalali.INSTANCE.equals(Chronology.from(temporal))) {
                temporal = LocalDateJalali.from(temporal);
            }
            return YearMonthJalali.of(temporal.get(ChronoField.YEAR), temporal.get(ChronoField.MONTH_OF_YEAR));
        }
        catch (DateTimeException ex) {
            throw new DateTimeException("Unable to obtain JalaliYearMonth from TemporalAccessor: " + String.valueOf(temporal) + " of type " + temporal.getClass().getName(), ex);
        }
    }

    public static YearMonthJalali parse(CharSequence text) {
        return YearMonthJalali.parse(text, PARSER);
    }

    public static YearMonthJalali parse(CharSequence text, DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.parse(text, YearMonthJalali::from);
    }

    private YearMonthJalali with(int newYear, int newMonth) {
        if (this.year == newYear && this.month == newMonth) {
            return this;
        }
        return new YearMonthJalali(newYear, newMonth);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return field == ChronoField.YEAR || field == ChronoField.MONTH_OF_YEAR || field == ChronoField.PROLEPTIC_MONTH || field == ChronoField.YEAR_OF_ERA || field == ChronoField.ERA;
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            return unit == ChronoUnit.MONTHS || unit == ChronoUnit.YEARS || unit == ChronoUnit.DECADES || unit == ChronoUnit.CENTURIES || unit == ChronoUnit.MILLENNIA || unit == ChronoUnit.ERAS;
        }
        return unit != null && unit.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field == ChronoField.YEAR_OF_ERA) {
            return this.getYear() <= 0 ? ValueRange.of(1L, 1000000000L) : ValueRange.of(1L, 999999999L);
        }
        return Temporal.super.range(field);
    }

    @Override
    public int get(TemporalField field) {
        return this.range(field).checkValidIntValue(this.getLong(field), field);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            switch ((ChronoField)field) {
                case MONTH_OF_YEAR: {
                    return this.month;
                }
                case PROLEPTIC_MONTH: {
                    return this.getProlepticMonth();
                }
                case YEAR_OF_ERA: {
                    return this.year < 1 ? 1 - this.year : this.year;
                }
                case YEAR: {
                    return this.year;
                }
                case ERA: {
                    return this.year < 1 ? 0 : 1;
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + String.valueOf(field));
        }
        return field.getFrom(this);
    }

    private long getProlepticMonth() {
        return (long)this.year * 12L + (long)this.month - 1L;
    }

    public int getMonthValue() {
        return this.month;
    }

    public MonthJalali getMonth() {
        return MonthJalali.of(this.month);
    }

    public boolean isLeapYear() {
        return ChronologyJalali.INSTANCE.isLeapYear(this.year);
    }

    public boolean isValidDay(int dayOfMonth) {
        return dayOfMonth >= 1 && dayOfMonth <= this.lengthOfMonth();
    }

    public int lengthOfMonth() {
        return this.getMonth().length(this.isLeapYear());
    }

    public int lengthOfYear() {
        return this.isLeapYear() ? 366 : 365;
    }

    @Override
    public YearMonthJalali with(TemporalAdjuster adjuster) {
        return (YearMonthJalali)adjuster.adjustInto(this);
    }

    @Override
    public YearMonthJalali with(TemporalField field, long newValue) {
        if (field instanceof ChronoField) {
            ChronoField f = (ChronoField)field;
            f.checkValidValue(newValue);
            switch (f) {
                case MONTH_OF_YEAR: {
                    return this.withMonth((int)newValue);
                }
                case PROLEPTIC_MONTH: {
                    return this.plusMonths(newValue - this.getProlepticMonth());
                }
                case YEAR_OF_ERA: {
                    return this.withYear((int)(this.year < 1 ? 1L - newValue : newValue));
                }
                case YEAR: {
                    return this.withYear((int)newValue);
                }
                case ERA: {
                    return this.getLong(ChronoField.ERA) == newValue ? this : this.withYear(1 - this.year);
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + String.valueOf(field));
        }
        return field.adjustInto(this, newValue);
    }

    public YearMonthJalali withYear(int year) {
        ChronoField.YEAR.checkValidValue(year);
        return this.with(year, this.month);
    }

    public YearMonthJalali withMonth(int month) {
        ChronoField.MONTH_OF_YEAR.checkValidValue(month);
        return this.with(this.year, month);
    }

    @Override
    public YearMonthJalali plus(TemporalAmount amountToAdd) {
        return (YearMonthJalali)amountToAdd.addTo(this);
    }

    @Override
    public YearMonthJalali plus(long amountToAdd, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            switch ((ChronoUnit)unit) {
                case MONTHS: {
                    return this.plusMonths(amountToAdd);
                }
                case YEARS: {
                    return this.plusYears(amountToAdd);
                }
                case DECADES: {
                    return this.plusYears(Math.multiplyExact(amountToAdd, 10L));
                }
                case CENTURIES: {
                    return this.plusYears(Math.multiplyExact(amountToAdd, 100L));
                }
                case MILLENNIA: {
                    return this.plusYears(Math.multiplyExact(amountToAdd, 1000L));
                }
                case ERAS: {
                    return this.with(ChronoField.ERA, Math.addExact(this.getLong(ChronoField.ERA), amountToAdd));
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + String.valueOf(unit));
        }
        return unit.addTo(this, amountToAdd);
    }

    public YearMonthJalali plusYears(long yearsToAdd) {
        if (yearsToAdd == 0L) {
            return this;
        }
        int newYear = ChronoField.YEAR.checkValidIntValue((long)this.year + yearsToAdd);
        return this.with(newYear, this.month);
    }

    public YearMonthJalali plusMonths(long monthsToAdd) {
        if (monthsToAdd == 0L) {
            return this;
        }
        long monthCount = (long)this.year * 12L + (long)(this.month - 1);
        long calcMonths = monthCount + monthsToAdd;
        int newYear = ChronoField.YEAR.checkValidIntValue(Math.floorDiv(calcMonths, 12L));
        long newMonth = Math.floorMod(calcMonths, 12L) + 1L;
        return this.with(newYear, (int)newMonth);
    }

    @Override
    public YearMonthJalali minus(TemporalAmount amountToSubtract) {
        return (YearMonthJalali)amountToSubtract.subtractFrom(this);
    }

    @Override
    public YearMonthJalali minus(long amountToSubtract, TemporalUnit unit) {
        return amountToSubtract == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, unit).plus(1L, unit) : this.plus(-amountToSubtract, unit);
    }

    public YearMonthJalali minusYears(long yearsToSubtract) {
        return yearsToSubtract == Long.MIN_VALUE ? this.plusYears(Long.MAX_VALUE).plusYears(1L) : this.plusYears(-yearsToSubtract);
    }

    public YearMonthJalali minusMonths(long monthsToSubtract) {
        return monthsToSubtract == Long.MIN_VALUE ? this.plusMonths(Long.MAX_VALUE).plusMonths(1L) : this.plusMonths(-monthsToSubtract);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.chronology()) {
            return (R)ChronologyJalali.INSTANCE;
        }
        if (query == TemporalQueries.precision()) {
            return (R)ChronoUnit.MONTHS;
        }
        return Temporal.super.query(query);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        if (!Chronology.from(temporal).equals(ChronologyJalali.INSTANCE)) {
            throw new DateTimeException("Adjustment only supported on ISO date-time");
        }
        return temporal.with(ChronoField.PROLEPTIC_MONTH, this.getProlepticMonth());
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        YearMonthJalali end = YearMonthJalali.from(endExclusive);
        if (unit instanceof ChronoUnit) {
            long monthsUntil = end.getProlepticMonth() - this.getProlepticMonth();
            switch ((ChronoUnit)unit) {
                case MONTHS: {
                    return monthsUntil;
                }
                case YEARS: {
                    return monthsUntil / 12L;
                }
                case DECADES: {
                    return monthsUntil / 120L;
                }
                case CENTURIES: {
                    return monthsUntil / 1200L;
                }
                case MILLENNIA: {
                    return monthsUntil / 12000L;
                }
                case ERAS: {
                    return end.getLong(ChronoField.ERA) - this.getLong(ChronoField.ERA);
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + String.valueOf(unit));
        }
        return unit.between(this, end);
    }

    public String format(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.format(this);
    }

    public LocalDateJalali atDay(int dayOfMonth) {
        return LocalDateJalali.of(this.year, this.month, dayOfMonth);
    }

    public LocalDateJalali atEndOfMonth() {
        return LocalDateJalali.of(this.year, this.month, this.lengthOfMonth());
    }

    @Override
    public int compareTo(YearMonthJalali other) {
        int cmp = this.year - other.year;
        if (cmp == 0) {
            cmp = this.month - other.month;
        }
        return cmp;
    }

    public boolean isAfter(YearMonthJalali other) {
        return this.compareTo(other) > 0;
    }

    public boolean isBefore(YearMonthJalali other) {
        return this.compareTo(other) < 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof YearMonthJalali) {
            YearMonthJalali other = (YearMonthJalali)obj;
            return this.year == other.year && this.month == other.month;
        }
        return false;
    }

    public int hashCode() {
        return this.year ^ this.month << 27;
    }

    public String toString() {
        int absYear = Math.abs(this.year);
        StringBuilder buf = new StringBuilder(9);
        if (absYear < 1000) {
            if (this.year < 0) {
                buf.append(this.year - 10000).deleteCharAt(1);
            } else {
                buf.append(this.year + 10000).deleteCharAt(0);
            }
        } else {
            buf.append(this.year);
        }
        return buf.append(this.month < 10 ? "-0" : "-").append(this.month).toString();
    }

    @Generated
    public int getYear() {
        return this.year;
    }
}

