/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Objects;
import org.bardframework.time.ChronologyJalali;
import org.bardframework.time.LocalDateJalali;
import org.bardframework.time.MonthDayJalali;
import org.bardframework.time.MonthJalali;
import org.bardframework.time.YearMonthJalali;

public final class YearJalali
implements Temporal,
TemporalAdjuster,
Comparable<YearJalali>,
Serializable {
    public static final int MIN_VALUE = -999999999;
    public static final int MAX_VALUE = 999999999;
    private static final int[] validRemaining_after_474 = new int[]{0, 4, 8, 12, 16, 20, 24, 29, 33, 37, 41, 45, 49, 53, 57, 62, 66, 70, 74, 78, 82, 86, 90, 95, 99, 103, 107, 111, 115, 119, 124};
    private static final int[] validRemaining_before_474 = new int[]{0, 4, 8, 12, 16, 20, 25, 29, 33, 37, 41, 45, 49, 53, 58, 62, 66, 70, 74, 78, 82, 86, 91, 95, 99, 103, 107, 111, 115, 120, 124};
    private static final long serialVersionUID = -23038383694477807L;
    private static final DateTimeFormatter PARSER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).toFormatter();
    private final int year;

    private YearJalali(int year) {
        this.year = year;
    }

    public static YearJalali now() {
        return YearJalali.now(Clock.systemDefaultZone());
    }

    public static YearJalali now(ZoneId zone) {
        return YearJalali.now(Clock.system(zone));
    }

    public static YearJalali now(Clock clock) {
        LocalDateJalali now = LocalDateJalali.now(clock);
        return YearJalali.of(now.getYear());
    }

    public static YearJalali of(int isoYear) throws DateTimeException {
        ChronoField.YEAR.checkValidValue(isoYear);
        return new YearJalali(isoYear);
    }

    public static YearJalali from(TemporalAccessor temporal) {
        if (temporal instanceof YearJalali) {
            return (YearJalali)temporal;
        }
        Objects.requireNonNull(temporal, "temporal");
        try {
            if (!ChronologyJalali.INSTANCE.equals(Chronology.from(temporal))) {
                temporal = LocalDateJalali.from(temporal);
            }
            return YearJalali.of(temporal.get(ChronoField.YEAR));
        }
        catch (DateTimeException ex) {
            throw new DateTimeException("Unable to obtain JalaliYear from TemporalAccessor: " + String.valueOf(temporal) + " of type " + temporal.getClass().getName(), ex);
        }
    }

    public static YearJalali parse(CharSequence text) {
        return YearJalali.parse(text, PARSER);
    }

    public static YearJalali parse(CharSequence text, DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.parse(text, YearJalali::from);
    }

    public static boolean isLeap(long year) {
        return year % 33L == 1L || year % 33L == 5L || year % 33L == 9L || year % 33L == 13L || year % 33L == 17L || year % 33L == 22L || year % 33L == 26L || year % 33L == 30L;
    }

    public int getValue() {
        return this.year;
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return field == ChronoField.YEAR || field == ChronoField.YEAR_OF_ERA || field == ChronoField.ERA;
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            return unit == ChronoUnit.YEARS || unit == ChronoUnit.DECADES || unit == ChronoUnit.CENTURIES || unit == ChronoUnit.MILLENNIA || unit == ChronoUnit.ERAS;
        }
        return unit != null && unit.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field == ChronoField.YEAR_OF_ERA) {
            return this.year <= 0 ? ValueRange.of(1L, 1000000000L) : ValueRange.of(1L, 999999999L);
        }
        return Temporal.super.range(field);
    }

    @Override
    public int get(TemporalField field) {
        return this.range(field).checkValidIntValue(this.getLong(field), field);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            switch ((ChronoField)field) {
                case YEAR_OF_ERA: {
                    return this.year < 1 ? 1 - this.year : this.year;
                }
                case YEAR: {
                    return this.year;
                }
                case ERA: {
                    return this.year < 1 ? 0 : 1;
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + String.valueOf(field));
        }
        return field.getFrom(this);
    }

    public boolean isLeap() {
        return YearJalali.isLeap(this.year);
    }

    public boolean isValidMonthDay(MonthDayJalali monthDay) {
        return monthDay != null && monthDay.isValidYear(this.year);
    }

    public int length() {
        return this.isLeap() ? 366 : 365;
    }

    @Override
    public YearJalali with(TemporalAdjuster adjuster) {
        return (YearJalali)adjuster.adjustInto(this);
    }

    @Override
    public YearJalali with(TemporalField field, long newValue) {
        if (field instanceof ChronoField) {
            ChronoField f = (ChronoField)field;
            f.checkValidValue(newValue);
            switch (f) {
                case YEAR_OF_ERA: {
                    return YearJalali.of((int)(this.year < 1 ? 1L - newValue : newValue));
                }
                case YEAR: {
                    return YearJalali.of((int)newValue);
                }
                case ERA: {
                    return this.getLong(ChronoField.ERA) == newValue ? this : YearJalali.of(1 - this.year);
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + String.valueOf(field));
        }
        return field.adjustInto(this, newValue);
    }

    @Override
    public YearJalali plus(TemporalAmount amountToAdd) {
        return (YearJalali)amountToAdd.addTo(this);
    }

    @Override
    public YearJalali plus(long amountToAdd, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            switch ((ChronoUnit)unit) {
                case YEARS: {
                    return this.plusYears(amountToAdd);
                }
                case DECADES: {
                    return this.plusYears(Math.multiplyExact(amountToAdd, 10L));
                }
                case CENTURIES: {
                    return this.plusYears(Math.multiplyExact(amountToAdd, 100L));
                }
                case MILLENNIA: {
                    return this.plusYears(Math.multiplyExact(amountToAdd, 1000L));
                }
                case ERAS: {
                    return this.with(ChronoField.ERA, Math.addExact(this.getLong(ChronoField.ERA), amountToAdd));
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + String.valueOf(unit));
        }
        return unit.addTo(this, amountToAdd);
    }

    public YearJalali plusYears(long yearsToAdd) {
        if (yearsToAdd == 0L) {
            return this;
        }
        return YearJalali.of(ChronoField.YEAR.checkValidIntValue((long)this.year + yearsToAdd));
    }

    @Override
    public YearJalali minus(TemporalAmount amountToSubtract) {
        return (YearJalali)amountToSubtract.subtractFrom(this);
    }

    @Override
    public YearJalali minus(long amountToSubtract, TemporalUnit unit) {
        return amountToSubtract == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, unit).plus(1L, unit) : this.plus(-amountToSubtract, unit);
    }

    public YearJalali minusYears(long yearsToSubtract) {
        return yearsToSubtract == Long.MIN_VALUE ? this.plusYears(Long.MAX_VALUE).plusYears(1L) : this.plusYears(-yearsToSubtract);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.chronology()) {
            return (R)ChronologyJalali.INSTANCE;
        }
        if (query == TemporalQueries.precision()) {
            return (R)ChronoUnit.YEARS;
        }
        return Temporal.super.query(query);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        if (!Chronology.from(temporal).equals(ChronologyJalali.INSTANCE)) {
            throw new DateTimeException("Adjustment only supported on ISO date-time");
        }
        return temporal.with(ChronoField.YEAR, this.year);
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        YearJalali end = YearJalali.from(endExclusive);
        if (unit instanceof ChronoUnit) {
            long yearsUntil = (long)end.year - (long)this.year;
            switch ((ChronoUnit)unit) {
                case YEARS: {
                    return yearsUntil;
                }
                case DECADES: {
                    return yearsUntil / 10L;
                }
                case CENTURIES: {
                    return yearsUntil / 100L;
                }
                case MILLENNIA: {
                    return yearsUntil / 1000L;
                }
                case ERAS: {
                    return end.getLong(ChronoField.ERA) - this.getLong(ChronoField.ERA);
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + String.valueOf(unit));
        }
        return unit.between(this, end);
    }

    public String format(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.format(this);
    }

    public LocalDateJalali atDay(int dayOfYear) {
        return LocalDateJalali.ofYearDay(this.year, dayOfYear);
    }

    public YearMonthJalali atMonth(MonthJalali month) {
        return YearMonthJalali.of(this.year, month);
    }

    public YearMonthJalali atMonth(int month) {
        return YearMonthJalali.of(this.year, month);
    }

    public LocalDateJalali atMonthDay(MonthDayJalali monthDay) {
        return monthDay.atYear(this.year);
    }

    @Override
    public int compareTo(YearJalali other) {
        return this.year - other.year;
    }

    public boolean isAfter(YearJalali other) {
        return this.year > other.year;
    }

    public boolean isBefore(YearJalali other) {
        return this.year < other.year;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof YearJalali) {
            return this.year == ((YearJalali)obj).year;
        }
        return false;
    }

    public int hashCode() {
        return this.year;
    }

    public String toString() {
        return Integer.toString(this.year);
    }
}

