/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.time.zone.ZoneRules;
import java.util.Comparator;
import java.util.Objects;
import lombok.Generated;
import org.bardframework.time.LocalDateJalali;
import org.bardframework.time.LocalDateTimeJalali;
import org.bardframework.time.MonthJalali;
import org.bardframework.time.ZonedDateTimeJalali;
import org.bardframework.time.temporal.TemporalQueriesJalali;

public final class OffsetDateTimeJalali
implements Temporal,
TemporalAdjuster,
Comparable<OffsetDateTimeJalali>,
Serializable {
    public static final OffsetDateTimeJalali MIN = LocalDateTimeJalali.MIN.atOffset(ZoneOffset.MAX);
    public static final OffsetDateTimeJalali MAX = LocalDateTimeJalali.MAX.atOffset(ZoneOffset.MIN);
    private static final long serialVersionUID = 2287754244819255394L;
    private final LocalDateTimeJalali dateTime;
    private final ZoneOffset offset;

    private OffsetDateTimeJalali(LocalDateTimeJalali dateTime, ZoneOffset offset) {
        this.dateTime = Objects.requireNonNull(dateTime, "dateTime");
        this.offset = Objects.requireNonNull(offset, "offset");
    }

    public static Comparator<OffsetDateTimeJalali> timeLineOrder() {
        return OffsetDateTimeJalali::compareInstant;
    }

    private static int compareInstant(OffsetDateTimeJalali datetime1, OffsetDateTimeJalali datetime2) {
        if (datetime1.getOffset().equals(datetime2.getOffset())) {
            return datetime1.toLocalDateTimeJalali().compareTo(datetime2.toLocalDateTimeJalali());
        }
        int cmp = Long.compare(datetime1.toEpochSecond(), datetime2.toEpochSecond());
        if (cmp == 0) {
            cmp = datetime1.toLocalTime().getNano() - datetime2.toLocalTime().getNano();
        }
        return cmp;
    }

    public static OffsetDateTimeJalali now() {
        return OffsetDateTimeJalali.now(Clock.systemDefaultZone());
    }

    public static OffsetDateTimeJalali now(ZoneId zone) {
        return OffsetDateTimeJalali.now(Clock.system(zone));
    }

    public static OffsetDateTimeJalali now(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        Instant now = clock.instant();
        return OffsetDateTimeJalali.ofInstant(now, clock.getZone().getRules().getOffset(now));
    }

    public static OffsetDateTimeJalali of(LocalDateJalali date, LocalTime time, ZoneOffset offset) {
        LocalDateTimeJalali dt = LocalDateTimeJalali.of(date, time);
        return new OffsetDateTimeJalali(dt, offset);
    }

    public static OffsetDateTimeJalali of(LocalDateTimeJalali dateTime, ZoneOffset offset) {
        return new OffsetDateTimeJalali(dateTime, offset);
    }

    public static OffsetDateTimeJalali of(int year, int month, int dayOfMonth, int hour, int minute, int second, int nanoOfSecond, ZoneOffset offset) {
        LocalDateTimeJalali dt = LocalDateTimeJalali.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond);
        return new OffsetDateTimeJalali(dt, offset);
    }

    public static OffsetDateTimeJalali ofInstant(Instant instant, ZoneId zone) {
        Objects.requireNonNull(instant, "instant");
        Objects.requireNonNull(zone, "zone");
        ZoneRules rules = zone.getRules();
        ZoneOffset offset = rules.getOffset(instant);
        LocalDateTimeJalali ldt = LocalDateTimeJalali.ofEpochSecond(instant.getEpochSecond(), instant.getNano(), offset);
        return new OffsetDateTimeJalali(ldt, offset);
    }

    public static OffsetDateTimeJalali from(TemporalAccessor temporal) {
        if (temporal instanceof OffsetDateTimeJalali) {
            return (OffsetDateTimeJalali)temporal;
        }
        try {
            ZoneOffset offset = ZoneOffset.from(temporal);
            LocalDateJalali date = temporal.query(TemporalQueriesJalali.localDate());
            LocalTime time = temporal.query(TemporalQueries.localTime());
            if (date != null && time != null) {
                return OffsetDateTimeJalali.of(date, time, offset);
            }
            Instant instant = Instant.from(temporal);
            return OffsetDateTimeJalali.ofInstant(instant, offset);
        }
        catch (DateTimeException ex) {
            throw new DateTimeException("Unable to obtain OffsetDateTime from TemporalAccessor: " + String.valueOf(temporal) + " of type " + temporal.getClass().getName(), ex);
        }
    }

    public static OffsetDateTimeJalali parse(CharSequence text) {
        return OffsetDateTimeJalali.parse(text, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public static OffsetDateTimeJalali parse(CharSequence text, DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.parse(text, OffsetDateTimeJalali::from);
    }

    private OffsetDateTimeJalali with(LocalDateTimeJalali dateTime, ZoneOffset offset) {
        if (this.dateTime == dateTime && this.offset.equals(offset)) {
            return this;
        }
        return new OffsetDateTimeJalali(dateTime, offset);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        return field instanceof ChronoField || field != null && field.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            return unit != ChronoUnit.FOREVER;
        }
        return unit != null && unit.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field instanceof ChronoField) {
            if (field == ChronoField.INSTANT_SECONDS || field == ChronoField.OFFSET_SECONDS) {
                return field.range();
            }
            return this.dateTime.range(field);
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField field) {
        if (field instanceof ChronoField) {
            switch ((ChronoField)field) {
                case INSTANT_SECONDS: {
                    throw new UnsupportedTemporalTypeException("Invalid field 'InstantSeconds' for get() method, use getLong() instead");
                }
                case OFFSET_SECONDS: {
                    return this.getOffset().getTotalSeconds();
                }
            }
            return this.dateTime.get(field);
        }
        return Temporal.super.get(field);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            switch ((ChronoField)field) {
                case INSTANT_SECONDS: {
                    return this.toEpochSecond();
                }
                case OFFSET_SECONDS: {
                    return this.getOffset().getTotalSeconds();
                }
            }
            return this.dateTime.getLong(field);
        }
        return field.getFrom(this);
    }

    public OffsetDateTimeJalali withOffsetSameLocal(ZoneOffset offset) {
        return this.with(this.dateTime, offset);
    }

    public OffsetDateTimeJalali withOffsetSameInstant(ZoneOffset offset) {
        if (offset.equals(this.offset)) {
            return this;
        }
        int difference = offset.getTotalSeconds() - this.offset.getTotalSeconds();
        LocalDateTimeJalali adjusted = this.dateTime.plusSeconds(difference);
        return new OffsetDateTimeJalali(adjusted, offset);
    }

    public LocalDateTimeJalali toLocalDateTimeJalali() {
        return this.dateTime;
    }

    public LocalDateJalali toLocalDate() {
        return this.dateTime.toLocalDate();
    }

    public int getYear() {
        return this.dateTime.getYear();
    }

    public int getMonthValue() {
        return this.dateTime.getMonthValue();
    }

    public MonthJalali getMonth() {
        return this.dateTime.getMonth();
    }

    public int getDayOfMonth() {
        return this.dateTime.getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.dateTime.getDayOfYear();
    }

    public DayOfWeek getDayOfWeek() {
        return this.dateTime.getDayOfWeek();
    }

    public LocalTime toLocalTime() {
        return this.dateTime.toLocalTime();
    }

    public int getHour() {
        return this.dateTime.getHour();
    }

    public int getMinute() {
        return this.dateTime.getMinute();
    }

    public int getSecond() {
        return this.dateTime.getSecond();
    }

    public int getNano() {
        return this.dateTime.getNano();
    }

    @Override
    public OffsetDateTimeJalali with(TemporalAdjuster adjuster) {
        if (adjuster instanceof LocalDateJalali || adjuster instanceof LocalTime || adjuster instanceof LocalDateTimeJalali) {
            return this.with(this.dateTime.with(adjuster), this.offset);
        }
        if (adjuster instanceof Instant) {
            return OffsetDateTimeJalali.ofInstant((Instant)adjuster, this.offset);
        }
        if (adjuster instanceof ZoneOffset) {
            return this.with(this.dateTime, (ZoneOffset)adjuster);
        }
        if (adjuster instanceof OffsetDateTimeJalali) {
            return (OffsetDateTimeJalali)adjuster;
        }
        return (OffsetDateTimeJalali)adjuster.adjustInto(this);
    }

    @Override
    public OffsetDateTimeJalali with(TemporalField field, long newValue) {
        if (field instanceof ChronoField) {
            ChronoField f = (ChronoField)field;
            switch (f) {
                case INSTANT_SECONDS: {
                    return OffsetDateTimeJalali.ofInstant(Instant.ofEpochSecond(newValue, this.getNano()), this.offset);
                }
                case OFFSET_SECONDS: {
                    return this.with(this.dateTime, ZoneOffset.ofTotalSeconds(f.checkValidIntValue(newValue)));
                }
            }
            return this.with(this.dateTime.with(field, newValue), this.offset);
        }
        return field.adjustInto(this, newValue);
    }

    public OffsetDateTimeJalali withYear(int year) {
        return this.with(this.dateTime.withYear(year), this.offset);
    }

    public OffsetDateTimeJalali withMonth(int month) {
        return this.with(this.dateTime.withMonth(month), this.offset);
    }

    public OffsetDateTimeJalali withDayOfMonth(int dayOfMonth) {
        return this.with(this.dateTime.withDayOfMonth(dayOfMonth), this.offset);
    }

    public OffsetDateTimeJalali withDayOfYear(int dayOfYear) {
        return this.with(this.dateTime.withDayOfYear(dayOfYear), this.offset);
    }

    public OffsetDateTimeJalali withHour(int hour) {
        return this.with(this.dateTime.withHour(hour), this.offset);
    }

    public OffsetDateTimeJalali withMinute(int minute) {
        return this.with(this.dateTime.withMinute(minute), this.offset);
    }

    public OffsetDateTimeJalali withSecond(int second) {
        return this.with(this.dateTime.withSecond(second), this.offset);
    }

    public OffsetDateTimeJalali withNano(int nanoOfSecond) {
        return this.with(this.dateTime.withNano(nanoOfSecond), this.offset);
    }

    public OffsetDateTimeJalali truncatedTo(TemporalUnit unit) {
        return this.with(this.dateTime.truncatedTo(unit), this.offset);
    }

    @Override
    public OffsetDateTimeJalali plus(TemporalAmount amountToAdd) {
        return (OffsetDateTimeJalali)amountToAdd.addTo(this);
    }

    @Override
    public OffsetDateTimeJalali plus(long amountToAdd, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            return this.with(this.dateTime.plus(amountToAdd, unit), this.offset);
        }
        return unit.addTo(this, amountToAdd);
    }

    public OffsetDateTimeJalali plusYears(long years) {
        return this.with(this.dateTime.plusYears(years), this.offset);
    }

    public OffsetDateTimeJalali plusMonths(long months) {
        return this.with(this.dateTime.plusMonths(months), this.offset);
    }

    public OffsetDateTimeJalali plusWeeks(long weeks) {
        return this.with(this.dateTime.plusWeeks(weeks), this.offset);
    }

    public OffsetDateTimeJalali plusDays(long days) {
        return this.with(this.dateTime.plusDays(days), this.offset);
    }

    public OffsetDateTimeJalali plusHours(long hours) {
        return this.with(this.dateTime.plusHours(hours), this.offset);
    }

    public OffsetDateTimeJalali plusMinutes(long minutes) {
        return this.with(this.dateTime.plusMinutes(minutes), this.offset);
    }

    public OffsetDateTimeJalali plusSeconds(long seconds) {
        return this.with(this.dateTime.plusSeconds(seconds), this.offset);
    }

    public OffsetDateTimeJalali plusNanos(long nanos) {
        return this.with(this.dateTime.plusNanos(nanos), this.offset);
    }

    @Override
    public OffsetDateTimeJalali minus(TemporalAmount amountToSubtract) {
        return (OffsetDateTimeJalali)amountToSubtract.subtractFrom(this);
    }

    @Override
    public OffsetDateTimeJalali minus(long amountToSubtract, TemporalUnit unit) {
        return amountToSubtract == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, unit).plus(1L, unit) : this.plus(-amountToSubtract, unit);
    }

    public OffsetDateTimeJalali minusYears(long years) {
        return years == Long.MIN_VALUE ? this.plusYears(Long.MAX_VALUE).plusYears(1L) : this.plusYears(-years);
    }

    public OffsetDateTimeJalali minusMonths(long months) {
        return months == Long.MIN_VALUE ? this.plusMonths(Long.MAX_VALUE).plusMonths(1L) : this.plusMonths(-months);
    }

    public OffsetDateTimeJalali minusWeeks(long weeks) {
        return weeks == Long.MIN_VALUE ? this.plusWeeks(Long.MAX_VALUE).plusWeeks(1L) : this.plusWeeks(-weeks);
    }

    public OffsetDateTimeJalali minusDays(long days) {
        return days == Long.MIN_VALUE ? this.plusDays(Long.MAX_VALUE).plusDays(1L) : this.plusDays(-days);
    }

    public OffsetDateTimeJalali minusHours(long hours) {
        return hours == Long.MIN_VALUE ? this.plusHours(Long.MAX_VALUE).plusHours(1L) : this.plusHours(-hours);
    }

    public OffsetDateTimeJalali minusMinutes(long minutes) {
        return minutes == Long.MIN_VALUE ? this.plusMinutes(Long.MAX_VALUE).plusMinutes(1L) : this.plusMinutes(-minutes);
    }

    public OffsetDateTimeJalali minusSeconds(long seconds) {
        return seconds == Long.MIN_VALUE ? this.plusSeconds(Long.MAX_VALUE).plusSeconds(1L) : this.plusSeconds(-seconds);
    }

    public OffsetDateTimeJalali minusNanos(long nanos) {
        return nanos == Long.MIN_VALUE ? this.plusNanos(Long.MAX_VALUE).plusNanos(1L) : this.plusNanos(-nanos);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.offset() || query == TemporalQueries.zone()) {
            return (R)this.getOffset();
        }
        if (query == TemporalQueries.zoneId()) {
            return null;
        }
        if (query == TemporalQueries.localDate()) {
            return (R)this.toLocalDate();
        }
        if (query == TemporalQueries.localTime()) {
            return (R)this.toLocalTime();
        }
        if (query == TemporalQueries.chronology()) {
            return (R)IsoChronology.INSTANCE;
        }
        if (query == TemporalQueries.precision()) {
            return (R)ChronoUnit.NANOS;
        }
        return query.queryFrom(this);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField.EPOCH_DAY, this.toLocalDate().toEpochDay()).with(ChronoField.NANO_OF_DAY, this.toLocalTime().toNanoOfDay()).with(ChronoField.OFFSET_SECONDS, this.getOffset().getTotalSeconds());
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        OffsetDateTimeJalali end = OffsetDateTimeJalali.from(endExclusive);
        if (unit instanceof ChronoUnit) {
            OffsetDateTimeJalali start = this;
            try {
                end = end.withOffsetSameInstant(this.offset);
            }
            catch (DateTimeException ex) {
                start = this.withOffsetSameInstant(end.offset);
            }
            return start.dateTime.until(end.dateTime, unit);
        }
        return unit.between(this, end);
    }

    public String format(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.format(this);
    }

    public ZonedDateTimeJalali atZoneSameInstant(ZoneId zone) {
        return ZonedDateTimeJalali.ofInstant(this.dateTime, this.offset, zone);
    }

    public ZonedDateTimeJalali atZoneSimilarLocal(ZoneId zone) {
        return ZonedDateTimeJalali.ofLocal(this.dateTime, zone, this.offset);
    }

    public OffsetTime toOffsetTime() {
        return OffsetTime.of(this.dateTime.toLocalTime(), this.offset);
    }

    public ZonedDateTimeJalali toZonedDateTime() {
        return ZonedDateTimeJalali.of(this.dateTime, this.offset);
    }

    public Instant toInstant() {
        return this.dateTime.toInstant(this.offset);
    }

    public long toEpochSecond() {
        return this.dateTime.toEpochSecond(this.offset);
    }

    @Override
    public int compareTo(OffsetDateTimeJalali other) {
        int cmp = OffsetDateTimeJalali.compareInstant(this, other);
        if (cmp == 0) {
            cmp = this.toLocalDateTimeJalali().compareTo(other.toLocalDateTimeJalali());
        }
        return cmp;
    }

    public boolean isAfter(OffsetDateTimeJalali other) {
        long otherEpochSec;
        long thisEpochSec = this.toEpochSecond();
        return thisEpochSec > (otherEpochSec = other.toEpochSecond()) || thisEpochSec == otherEpochSec && this.toLocalTime().getNano() > other.toLocalTime().getNano();
    }

    public boolean isBefore(OffsetDateTimeJalali other) {
        long otherEpochSec;
        long thisEpochSec = this.toEpochSecond();
        return thisEpochSec < (otherEpochSec = other.toEpochSecond()) || thisEpochSec == otherEpochSec && this.toLocalTime().getNano() < other.toLocalTime().getNano();
    }

    public boolean isEqual(OffsetDateTimeJalali other) {
        return this.toEpochSecond() == other.toEpochSecond() && this.toLocalTime().getNano() == other.toLocalTime().getNano();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof OffsetDateTimeJalali) {
            OffsetDateTimeJalali other = (OffsetDateTimeJalali)obj;
            return this.dateTime.equals(other.dateTime) && this.offset.equals(other.offset);
        }
        return false;
    }

    public int hashCode() {
        return this.dateTime.hashCode() ^ this.offset.hashCode();
    }

    public String toString() {
        return this.dateTime.toString() + String.valueOf(this.offset);
    }

    @Generated
    public LocalDateTimeJalali getDateTime() {
        return this.dateTime;
    }

    @Generated
    public ZoneOffset getOffset() {
        return this.offset;
    }
}

