/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.time.temporal;

import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import org.bardframework.time.LocalDateJalali;

public final class TemporalQueriesJalali {
    static final TemporalQuery<LocalDateJalali> LOCAL_DATE = new TemporalQuery<LocalDateJalali>(){

        @Override
        public LocalDateJalali queryFrom(TemporalAccessor temporal) {
            if (temporal.isSupported(ChronoField.EPOCH_DAY)) {
                return LocalDateJalali.ofEpochDay(temporal.getLong(ChronoField.EPOCH_DAY));
            }
            return null;
        }

        public String toString() {
            return "LocalDateJalali";
        }
    };

    private TemporalQueriesJalali() {
    }

    public static TemporalQuery<LocalDateJalali> localDate() {
        return LOCAL_DATE;
    }
}

