/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Objects;
import org.bardframework.time.ChronologyJalali;
import org.bardframework.time.LocalDateJalali;
import org.bardframework.time.MonthJalali;
import org.bardframework.time.YearJalali;

public final class MonthDayJalali
implements TemporalAccessor,
TemporalAdjuster,
Comparable<MonthDayJalali>,
Serializable {
    private static final long serialVersionUID = -939150713474957432L;
    private static final DateTimeFormatter PARSER = new DateTimeFormatterBuilder().appendLiteral("--").appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();
    private final int month;
    private final int day;

    private MonthDayJalali(int month, int dayOfMonth) {
        this.month = month;
        this.day = dayOfMonth;
    }

    public static MonthDayJalali now() {
        return MonthDayJalali.now(Clock.systemDefaultZone());
    }

    public static MonthDayJalali now(ZoneId zone) {
        return MonthDayJalali.now(Clock.system(zone));
    }

    public static MonthDayJalali now(Clock clock) {
        LocalDateJalali now = LocalDateJalali.now(clock);
        return MonthDayJalali.of(now.getMonth(), now.getDayOfMonth());
    }

    public static MonthDayJalali of(MonthJalali month, int dayOfMonth) {
        Objects.requireNonNull(month, "month");
        ChronoField.DAY_OF_MONTH.checkValidValue(dayOfMonth);
        if (dayOfMonth > month.maxLength()) {
            throw new DateTimeException("Illegal value for DayOfMonth field, value " + dayOfMonth + " is not valid for month " + month.name());
        }
        return new MonthDayJalali(month.getValue(), dayOfMonth);
    }

    public static MonthDayJalali of(int month, int dayOfMonth) {
        return MonthDayJalali.of(MonthJalali.of(month), dayOfMonth);
    }

    public static MonthDayJalali from(TemporalAccessor temporal) {
        if (temporal instanceof MonthDayJalali) {
            return (MonthDayJalali)temporal;
        }
        try {
            if (!ChronologyJalali.INSTANCE.equals(Chronology.from(temporal))) {
                temporal = LocalDateJalali.from(temporal);
            }
            return MonthDayJalali.of(temporal.get(ChronoField.MONTH_OF_YEAR), temporal.get(ChronoField.DAY_OF_MONTH));
        }
        catch (DateTimeException ex) {
            throw new DateTimeException("Unable to obtain JalaliMonthDay from TemporalAccessor: " + temporal + " of type " + temporal.getClass().getName(), ex);
        }
    }

    public static MonthDayJalali parse(CharSequence text) {
        return MonthDayJalali.parse(text, PARSER);
    }

    public static MonthDayJalali parse(CharSequence text, DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.parse(text, MonthDayJalali::from);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return field == ChronoField.MONTH_OF_YEAR || field == ChronoField.DAY_OF_MONTH;
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field == ChronoField.MONTH_OF_YEAR) {
            return field.range();
        }
        if (field == ChronoField.DAY_OF_MONTH) {
            return ValueRange.of(1L, this.getMonth().minLength(), this.getMonth().maxLength());
        }
        return TemporalAccessor.super.range(field);
    }

    @Override
    public int get(TemporalField field) {
        return this.range(field).checkValidIntValue(this.getLong(field), field);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            switch ((ChronoField)field) {
                case DAY_OF_MONTH: {
                    return this.day;
                }
                case MONTH_OF_YEAR: {
                    return this.month;
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return field.getFrom(this);
    }

    public int getMonthValue() {
        return this.month;
    }

    public MonthJalali getMonth() {
        return MonthJalali.of(this.month);
    }

    public int getDayOfMonth() {
        return this.day;
    }

    public boolean isValidYear(int year) {
        return this.day != 29 || this.month != 2 || YearJalali.isLeap(year);
    }

    public MonthDayJalali withMonth(int month) {
        return this.with(MonthJalali.of(month));
    }

    public MonthDayJalali with(MonthJalali month) {
        Objects.requireNonNull(month, "month");
        if (month.getValue() == this.month) {
            return this;
        }
        int day = Math.min(this.day, month.maxLength());
        return new MonthDayJalali(month.getValue(), day);
    }

    public MonthDayJalali withDayOfMonth(int dayOfMonth) {
        if (dayOfMonth == this.day) {
            return this;
        }
        return MonthDayJalali.of(this.month, dayOfMonth);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.chronology()) {
            return (R)ChronologyJalali.INSTANCE;
        }
        return TemporalAccessor.super.query(query);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        if (!Chronology.from(temporal).equals(ChronologyJalali.INSTANCE)) {
            throw new DateTimeException("Adjustment only supported on ISO date-time");
        }
        temporal = temporal.with(ChronoField.MONTH_OF_YEAR, this.month);
        return temporal.with(ChronoField.DAY_OF_MONTH, Math.min(temporal.range(ChronoField.DAY_OF_MONTH).getMaximum(), (long)this.day));
    }

    public String format(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.format(this);
    }

    public LocalDateJalali atYear(int year) {
        return LocalDateJalali.of(year, this.month, this.isValidYear(year) ? this.day : 28);
    }

    @Override
    public int compareTo(MonthDayJalali other) {
        int cmp = this.month - other.month;
        if (cmp == 0) {
            cmp = this.day - other.day;
        }
        return cmp;
    }

    public boolean isAfter(MonthDayJalali other) {
        return this.compareTo(other) > 0;
    }

    public boolean isBefore(MonthDayJalali other) {
        return this.compareTo(other) < 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MonthDayJalali) {
            MonthDayJalali other = (MonthDayJalali)obj;
            return this.month == other.month && this.day == other.day;
        }
        return false;
    }

    public int hashCode() {
        return (this.month << 6) + this.day;
    }

    public String toString() {
        return "--" + (this.month < 10 ? "0" : "") + this.month + (this.day < 10 ? "-0" : "-") + this.day;
    }
}

