/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.flow.processor.message.sender;

import jakarta.annotation.PostConstruct;
import java.time.LocalDateTime;
import java.time.chrono.HijrahDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.flow.exception.FlowExecutionException;
import org.bardframework.flow.processor.message.creator.MessageProvider;
import org.bardframework.flow.processor.message.sender.MessageSender;
import org.bardframework.time.LocalDateTimeJalali;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MessageSenderAbstract
implements MessageSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageSenderAbstract.class);
    protected final String receiverFieldName;
    protected final MessageProvider messageProvider;
    protected final String errorMessageKey;
    protected Pattern canSendRegex;
    protected Executor executor;
    protected int threadPoolSize = 100;
    protected boolean failOnError = true;
    protected boolean executeInNewThread = false;
    protected DateTimeFormatter dateFormatGregorian = DateTimeFormatter.ofPattern("yyyy/dd/MM");
    protected DateTimeFormatter dateFormatterJalali = DateTimeFormatter.ofPattern("yyyy/MM/dd");
    protected DateTimeFormatter dateFormatterHijrah = DateTimeFormatter.ofPattern("yyyy/MM/dd");
    protected DateTimeFormatter timeFormat = DateTimeFormatter.ofPattern("H:mm:ss");

    public MessageSenderAbstract(String receiverFieldName, MessageProvider messageProvider, String errorMessageKey) {
        this.receiverFieldName = receiverFieldName;
        this.messageProvider = messageProvider;
        this.errorMessageKey = errorMessageKey;
    }

    protected abstract void send(String var1, String var2, Map<String, Object> var3, Locale var4) throws Exception;

    @PostConstruct
    void init() {
        if (this.isExecuteInNewThread()) {
            this.executor = Executors.newFixedThreadPool(this.getThreadPoolSize());
        }
    }

    @Override
    public final void send(Map<String, Object> data, Locale locale) throws Exception {
        HashMap<String, Object> args = new HashMap<String, Object>(data);
        String message = this.getMessageProvider().create(args, locale);
        if (StringUtils.isBlank((CharSequence)message)) {
            log.warn("message is empty[{}], can't send it", args);
            throw new IllegalStateException("message provider generate empty message!");
        }
        Object receiver = data.get(this.getReceiverFieldName());
        if (null == receiver) {
            log.warn("receiver not exist for [{}], can't send message", args);
            throw new IllegalStateException("receiver not exist in args");
        }
        log.debug("sending message [{}]", (Object)message);
        if (this.isExecuteInNewThread()) {
            this.getExecutor().execute(() -> this.sendInternal(receiver.toString(), message, args, locale));
        } else {
            this.sendInternal(receiver.toString(), message, args, locale);
        }
    }

    private void sendInternal(String receiver, String message, Map<String, Object> args, Locale locale) {
        try {
            this.addExtraArgs(args);
            this.send(receiver, message, args, locale);
        }
        catch (Exception e) {
            log.error("error sending message, catching exception.", (Throwable)e);
            if (!this.isFailOnError()) {
                return;
            }
            throw new FlowExecutionException(List.of(this.errorMessageKey));
        }
    }

    protected void addExtraArgs(Map<String, Object> args) {
        LocalDateTime dateTime = LocalDateTime.now();
        args.put("date", dateTime.format(this.getDateFormatGregorian()));
        args.put("jalali_date", LocalDateTimeJalali.now().format(this.getDateFormatterJalali()));
        args.put("hijrah_date", HijrahDate.now().format(this.getDateFormatterHijrah()));
        args.put("time", dateTime.format(this.getTimeFormat()));
    }

    public void setCanSendRegex(String canSendRegex) {
        this.canSendRegex = Pattern.compile(canSendRegex);
    }

    @Override
    public Pattern canSendRegex() {
        return this.canSendRegex;
    }

    @Generated
    public String getReceiverFieldName() {
        return this.receiverFieldName;
    }

    @Generated
    public MessageProvider getMessageProvider() {
        return this.messageProvider;
    }

    @Generated
    public String getErrorMessageKey() {
        return this.errorMessageKey;
    }

    @Generated
    public Pattern getCanSendRegex() {
        return this.canSendRegex;
    }

    @Generated
    public Executor getExecutor() {
        return this.executor;
    }

    @Generated
    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    @Generated
    public boolean isFailOnError() {
        return this.failOnError;
    }

    @Generated
    public boolean isExecuteInNewThread() {
        return this.executeInNewThread;
    }

    @Generated
    public DateTimeFormatter getDateFormatGregorian() {
        return this.dateFormatGregorian;
    }

    @Generated
    public DateTimeFormatter getDateFormatterJalali() {
        return this.dateFormatterJalali;
    }

    @Generated
    public DateTimeFormatter getDateFormatterHijrah() {
        return this.dateFormatterHijrah;
    }

    @Generated
    public DateTimeFormatter getTimeFormat() {
        return this.timeFormat;
    }

    @Generated
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Generated
    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    @Generated
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @Generated
    public void setExecuteInNewThread(boolean executeInNewThread) {
        this.executeInNewThread = executeInNewThread;
    }

    @Generated
    public void setDateFormatGregorian(DateTimeFormatter dateFormatGregorian) {
        this.dateFormatGregorian = dateFormatGregorian;
    }

    @Generated
    public void setDateFormatterJalali(DateTimeFormatter dateFormatterJalali) {
        this.dateFormatterJalali = dateFormatterJalali;
    }

    @Generated
    public void setDateFormatterHijrah(DateTimeFormatter dateFormatterHijrah) {
        this.dateFormatterHijrah = dateFormatterHijrah;
    }

    @Generated
    public void setTimeFormat(DateTimeFormatter timeFormat) {
        this.timeFormat = timeFormat;
    }
}

